/***************************************************************************
                          wcard.h  -  description
                             -------------------
    begin                : Mon Nov 11 2002
    copyright            : (C) 2002 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef WCARD_H
#define WCARD_H

#include <iostream>
#include <fstream>
#include <sstream>
#include <vector>
using namespace std;

#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/ethernet.h>
#include <net/route.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>

#include <math.h>
#include <string.h>

#include "wcardlib.h"

/**
  *@author Matthias Reif
  */
class WCard {
public:
	WCard( const char* device );
	~WCard();
	int getLinkQual(int &link, int &avg, int &signal, int &noise, int &maxQual, int &maxSignal, int &maxNoise);
	int getNetID();
	void setDevice(const char* name);
	char* getIP();
	char* setIP( const char *ip );
	char* getDevice();
	int getProtocol(char *protocol);
	int getMode();
	int setMode(int mode);
	int getFreq();
	vector<int> getBitRates();
	int getBitRate( );
	int getAPMac(char *s);
	bool isWave();
	int getPower( bool& enabled, int& flags );
	int getTransmitPower( bool& disabled, bool& fixed, int& unit );
	int setTransmitPower( bool disabled, bool fixed, int value, int unit );
	bool getEncode(char* key);
	int getSensitivity( int &value, int &range );
	int setSensitivity( int value );
	int getRTS( iw_param& rts );
	int getFrag( iw_param& frag );
	int setRTS( iw_param rts );
	int setFrag( iw_param frag );
	bool hasLink();
	int setBitRate(int index);
	int getESSID(char *value);
	int setESSID(const char *value);
	bool getTraffic( double &sent, double &recv);
	int getNetworkID();
	int getNickName( char *name );
	int setNickName( const char *name );
	int getRetryLimit(int &value);
	int getRange();
	void setHas();
	static int channel2Frequency( int channel, double &frequency, const struct iw_range *	range );
	static void float2Frequency( double in, iw_freq* out );
	static double frequency2Float( iw_freq freq );
	int getFreguencyAndChannel( double &frequency, int &channel, int &numChannel );
	vector<APInfo> scan( int & error, int & errorNo );
	int getChannel( double frequency );
	int setChannel( double channel, bool fixed );
	int setPower( bool enable, int mode );
	static int frequency2Channel( double frequency, const struct iw_range* range );
	bool getStats( iw_discarded& discarded, int& missedBeacon );
	static int getWeVersion();
	char* getGateway();
	int setGateway( const char* ip );
	int deleteGateway( const char* ip );
	vector< EKey > getKeys();
	Encoding getEncoding();
	int setEncoding( int mode, int index, unsigned char* key, int length );
	int setEncoding( int index );
	int setEncodingMode( int mode );

	WInfo has;
	iwrange* range;
	
	static const double KILO = 1000.0;
	static const double MEGA = 1000000.0;
	static const double GIGA = 1000000000.0;
	
	static const int KILO_I = 1000;
	static const int MEGA_I = 1000000;
	static const int GIGA_I = 1000000000;

protected:
	int ethFD;
	char* device;

	struct iwreq* pwrq;
	struct iwreq wrq;
	
	iwstat* stats;
	
	char *rangeBuffer;

	FILE* procFile;
	char* procBuffer;
	static const int PROC_BUFFER_SIZE = 256;
	bool procSuccessful;

	// gateway stuff
	struct in_addr ip;

private:
	int iwIoctl( int code );
	static int extractEventStream(struct stream_descr* stream, struct iw_event* event, int we_version );
	struct rtentry createGatewayStruct( const char* ip );
	static void formatKey( EKey* key, int keyFlags );
};

#endif
