/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kuniqueapplication.h>
#include <kglobal.h>
#include <khelpmenu.h>
#include <kpopupmenu.h>

#include "kwirelessmonitor.h"
#include "timerthread.h"

static const char *description =
	I18N_NOOP("KWirelessMonitor");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

    KAboutData aboutData( "kwirelessmonitor", I18N_NOOP("KWirelessMonitor"),
            VERSION, description, KAboutData::License_GPL,
            "(c) 2004, An-Cheng Huang", 0, 0, "pach@cs.cmu.edu");
    aboutData.addAuthor("An-Cheng Huang",0, "pach@cs.cmu.edu");
    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
    KUniqueApplication::addCmdLineOptions();

    KUniqueApplication a;
    KWirelessMonitor *kwirelessmonitor = new KWirelessMonitor();
    a.setMainWidget(kwirelessmonitor);
    TimerThread *tthread = new TimerThread(kwirelessmonitor);
    kwirelessmonitor->setTimerThread(tthread);

    kwirelessmonitor->setScaledContents(false);
    kwirelessmonitor->show();

    tthread->start();

    return a.exec();
}
