/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//KDE Includes
#include <kiconloader.h>
#include <kpushbutton.h>
#include <kinputdialog.h>
#include <kmessagebox.h>

//QT Includes
#include <qlabel.h>

//kX Generator Includes
#include "ChangeEntriesDialog.h"


ChangeEntriesDialog :: ChangeEntriesDialog(QWidget *Parent, Xorg *Xorg, Section SectionName)
    : KDialog( Parent, "Change Entries Dialog" )

{
X = Xorg;
PassedSection = SectionName;
KIconLoader *Icons = new KIconLoader();


HistoryCount = 0;


   for (int a = 0; a <= 128; a++)
    {
     History[a] = "";
    }



//Window properties
   setPlainCaption(Locale(6) + Locale(SectionName));
   setMinimumSize(600, 400);
   setMaximumSize(600, 400);
//Pixmap
   QLabel *Pixmap = new QLabel(this);
    Pixmap->setGeometry(462, 10, 128, 128);
    Pixmap->setPixmap(Icons->loadIcon("system", KIcon::Desktop, KIcon::SizeEnormous));
//Logo Label
   QLabel *LogoLabel = new QLabel(this);
    LogoLabel->setText(Locale(8));
    LogoLabel->setFont(QFont("sans", 19, QFont::Normal, FALSE));
    LogoLabel->setGeometry(10, 10, 400, 35);
//Horizontal Line
   QFrame *Line = new QFrame(this);
    Line->setGeometry(QRect(10, 45, 450, 5));
    Line->setFrameShape( QFrame::HLine );
    Line->setFrameShadow( QFrame::Sunken );


//Info label
   QLabel *InformationLabel = new QLabel(this);
    InformationLabel->setGeometry(10, 60, 340, 50);
    InformationLabel->setText(Locale(7).arg(Locale(SectionName)));
    InformationLabel->setAlignment(QLabel::AlignTop | QLabel::WordBreak);

//OK Button
   KPushButton *OKButton = new KPushButton(this);
    OKButton->setGeometry(360, 360, 110, 29);
    OKButton->setText(Locale(9));
    OKButton->setIconSet(Icons->loadIcon("ok", KIcon::Desktop, KIcon::SizeSmall));

//Cancel Button
   KPushButton *CancelButton = new KPushButton(this);
    CancelButton->setGeometry(480, 360, 110, 29);
    CancelButton->setText(Locale(10));
    CancelButton->setIconSet(Icons->loadIcon("cancel", KIcon::Desktop, KIcon::SizeSmall));

//Horizontal Line
   QFrame *BottomLine = new QFrame(this);
    BottomLine->setGeometry(QRect(10, 350, 580, 5));
    BottomLine->setFrameShape( QFrame::HLine );
    BottomLine->setFrameShadow( QFrame::Sunken );

//Sections list box
   SectionsListBox = new KListBox(this);
    SectionsListBox->setGeometry(10, 120, 300, 220);

   KPushButton *AddButton = new KPushButton(this);
    AddButton->setGeometry(320, 120, 120, 25);
    AddButton->setText(Locale(11));
    AddButton->setIconSet(Icons->loadIcon("add", KIcon::Desktop, KIcon::SizeSmall));

   KPushButton *RemoveButton = new KPushButton(this);
    RemoveButton->setGeometry(320, 150, 120, 25);
    RemoveButton->setText(Locale(12));
    RemoveButton->setIconSet(Icons->loadIcon("remove", KIcon::Desktop, KIcon::SizeSmall));

   KPushButton *RenameButton = new KPushButton(this);
    RenameButton->setGeometry(320, 315, 120, 25);
    RenameButton->setText(Locale(13));
    RenameButton->setIconSet(Icons->loadIcon("reload", KIcon::Desktop, KIcon::SizeSmall));

//Connections
   connect (AddButton, SIGNAL(clicked()), this, SLOT(AddSectionDialog()));
   connect (RemoveButton, SIGNAL(clicked()), this, SLOT(RemoveSectionDialog()));
   connect (RenameButton, SIGNAL(clicked()), this, SLOT(RenameSectionDialog()));
   connect (OKButton, SIGNAL(clicked()), this, SLOT(SaveSettings()));
   connect (CancelButton, SIGNAL(clicked()), this, SLOT(reject()));


Init();
}

void ChangeEntriesDialog :: Init()
{
 if (PassedSection == ServerLayout) 
  {
   for (int a = 1; a <= X->CountSections(Xorg::ServerLayout); a++)
    {
     SectionsListBox->insertItem(X->GetValue(Xorg::ServerLayout, a, "Identifier", 1));
    }
  }

 if (PassedSection == Device) 
  {
   for (int a = 1; a <= X->CountSections(Xorg::Device); a++)
    {
     SectionsListBox->insertItem(X->GetValue(Xorg::Device, a, "Identifier", 1));
    }
  }

 if (PassedSection == Monitor) 
  {
   for (int a = 1; a <= X->CountSections(Xorg::Monitor); a++)
    {
     SectionsListBox->insertItem(X->GetValue(Xorg::Monitor, a, "Identifier", 1));
    }
  }

 if (PassedSection == Screen) 
  {
   for (int a = 1; a <= X->CountSections(Xorg::Screen); a++)
    {
     SectionsListBox->insertItem(X->GetValue(Xorg::Screen, a, "Identifier", 1));
    }
  }


 if (PassedSection == Pointer) 
  {
   for (int a = 1; a <= X->CountSections(Xorg::InputDevice); a++)
    {
     if (!X->isKeyboard(a)) { SectionsListBox->insertItem(X->GetValue(Xorg::InputDevice, a, "Identifier", 1)); }
    }
  }

 if (PassedSection == Keyboard) 
  {
   for (int a = 1; a <= X->CountSections(Xorg::InputDevice); a++)
    {
     if (X->isKeyboard(a)) { SectionsListBox->insertItem(X->GetValue(Xorg::InputDevice, a, "Identifier", 1)); }
    }
  }






SectionsListBox->setSelected(0, TRUE);
}

void ChangeEntriesDialog :: AddSectionDialog()
{
QString Result = KInputDialog::getText(Locale(14), Locale(15), QString::null);
if (Result == "") { return; }

if (X->isValuePresent("Identifier", Result))
   {
    KMessageBox::error(this, Locale(16), Locale(17));
    return;
   }



SectionsListBox->insertItem(Result);
History[HistoryCount] = "A," + Result;
HistoryCount++;

}

void ChangeEntriesDialog :: RemoveSectionDialog()
{

if (SectionsListBox->count() == 1)
 {
  KMessageBox::error(this, Locale(20), Locale(17));
  return;
 }


int Result = KMessageBox::questionYesNo(this, Locale(18).arg(SectionsListBox->text(SectionsListBox->currentItem())), Locale(19));

if (Result == KMessageBox::No) { return; }

if (Result == KMessageBox::Yes)
 {
  unsigned int CurrentItem = SectionsListBox->currentItem();
  SectionsListBox->removeItem(SectionsListBox->currentItem());
  if (CurrentItem < SectionsListBox->count()) { SectionsListBox->setSelected(CurrentItem, TRUE); }
  if (CurrentItem >= SectionsListBox->count()) { SectionsListBox->setSelected(CurrentItem - 1, TRUE); }
  QString num;
  num = num.setNum(CurrentItem + 1);
  History[HistoryCount] = "X," + num;
  HistoryCount++;
  return;
 }

}



void ChangeEntriesDialog :: RenameSectionDialog()
{
QString NewName = KInputDialog::getText(Locale(21), Locale(22), SectionsListBox->text(SectionsListBox->currentItem()));

if (NewName == "") { return; }

if (X->isValuePresent("Identifier", NewName))
   {
    KMessageBox::error(this, Locale(16), Locale(17));
    return;
   }

SectionsListBox->changeItem(NewName, SectionsListBox->currentItem());

  QString num;
  num = num.setNum(SectionsListBox->currentItem() + 1);
  History[HistoryCount] = "R," + num + "," + NewName;
  HistoryCount++;

}

void ChangeEntriesDialog :: SaveSettings()
{


for (int x = 0; x <= HistoryCount; x++)
  {
   QString Short = History[x];

   if (Short.section(",", 0, 0) == "A")
    {

     if (PassedSection == ServerLayout)
       {
        X->AddSection(Xorg::ServerLayout, "\nIdentifier \"" + Short.section(",", 1, 1) + "\"\n");
       }

     if (PassedSection == Device)
       {
        X->AddSection(Xorg::Device, "\nIdentifier \"" + Short.section(",", 1, 1) + "\"\n");
       }

     if (PassedSection == Monitor)
       {
        X->AddSection(Xorg::Monitor, "\nIdentifier \"" + Short.section(",", 1, 1) + "\"\n");
       }
     if (PassedSection == Screen)
       {
        X->AddSection(Xorg::Screen, "\nIdentifier \"" + Short.section(",", 1, 1) + "\"");
        X->WriteValue(Xorg::Screen, X->CountSections(Xorg::Screen), "Device",  X->GetValue(Xorg::Device, 1, "Identifier", 1));
        X->WriteValue(Xorg::Screen, X->CountSections(Xorg::Screen), "Monitor",  X->GetValue(Xorg::Monitor, 1, "Identifier", 1));
       }

     if (PassedSection == Pointer)
       {
         X->AddSection(Xorg::InputDevice, "\nIdentifier \"" + Short.section(",", 1, 1) + "\"\nDriver \"mouse\"");

       }

     if (PassedSection == Keyboard)
       {
        X->AddSection(Xorg::InputDevice, "\nIdentifier \"" + Short.section(",", 1, 1) + "\"\nDriver \"kbd\"");
       }

    }

   if (Short.section(",", 0, 0) == "R")
    {
     int toRename = 0;
     bool ok;
     toRename = Short.section(",", 1, 1).toInt(&ok, 10);

     if (PassedSection == ServerLayout)
       {
        X->WriteValue(Xorg::ServerLayout, toRename, "Identifier", Short.section(",", 2, 2));
       }

     if (PassedSection == Device)
       {
        QString OldName = X->GetValue(Xorg::Device, toRename, "Identifier", 1);
        X->ReplaceScreenValue("Device", OldName, Short.section(",", 2, 2));
        X->WriteValue(Xorg::Device, toRename, "Identifier", Short.section(",", 2, 2));
       }

     if (PassedSection == Monitor)
       {
        QString OldName = X->GetValue(Xorg::Monitor, toRename, "Identifier", 1);
        X->ReplaceScreenValue("Monitor", OldName, Short.section(",", 2, 2));
        X->WriteValue(Xorg::Monitor, toRename, "Identifier", Short.section(",", 2, 2));
       }

     if (PassedSection == Screen)
       {
        QString OldName = X->GetValue(Xorg::Screen, toRename, "Identifier", 1);
        X->ReplaceServerLayoutValue(OldName, Short.section(",", 2, 2));
        X->WriteValue(Xorg::Screen, toRename, "Identifier", Short.section(",", 2, 2));
       }

     if (PassedSection == Pointer)
       {
        QString OldName = X->GetValue(Xorg::InputDevice, X->PointerTranslate(toRename), "Identifier", 1);
        X->ReplaceServerLayoutValue(OldName, Short.section(",", 2, 2));
        X->WriteValue(Xorg::InputDevice, X->PointerTranslate(toRename), "Identifier", Short.section(",", 2, 2));
       }

     if (PassedSection == Keyboard)
       {
        QString OldName = X->GetValue(Xorg::InputDevice, X->KeyboardTranslate(toRename), "Identifier", 1);
        X->ReplaceServerLayoutValue(OldName, Short.section(",", 2, 2));
        X->WriteValue(Xorg::InputDevice, X->KeyboardTranslate(toRename), "Identifier", Short.section(",", 2, 2));
       }





    }

   if (Short.section(",", 0, 0) == "X")
    {
     int toRemove = 0;
     bool ok;
     toRemove = Short.section(",", 1, 1).toInt(&ok, 10);

     if (PassedSection == ServerLayout)
       {
        X->RemoveSection(Xorg::ServerLayout, toRemove);
       }

     if (PassedSection == Device)
       {
        X->RemoveSection(Xorg::Device, toRemove);
       }

     if (PassedSection == Monitor)
       {
        X->RemoveSection(Xorg::Monitor, toRemove);
       }

     if (PassedSection == Screen)
       {
        QString OldName = X->GetValue(Xorg::Screen, toRemove, "Identifier", 1);
        X->RemoveServerLayoutValue("Screen", OldName);
         X->RemoveSection(Xorg::Screen, toRemove);
       }

     if (PassedSection == Pointer)
       {
        QString OldName = X->GetValue(Xorg::InputDevice, X->PointerTranslate(toRemove), "Identifier", 1);
        X->RemoveServerLayoutValue("InputDevice", OldName);
        X->RemoveSection(Xorg::InputDevice, X->PointerTranslate(toRemove));
       }

     if (PassedSection == Keyboard)
       {
        QString OldName = X->GetValue(Xorg::InputDevice, X->KeyboardTranslate(toRemove), "Identifier", 1);
        X->RemoveServerLayoutValue("InputDevice", OldName);
        X->RemoveSection(Xorg::InputDevice, X->KeyboardTranslate(toRemove));
       }
    }

  }




close();
}
