/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//KDE Includes
#include <kiconloader.h>
#include <kmessagebox.h>

//QT Includes
#include <qlabel.h>
#include <qfile.h>

//kX Generator Includes
#include "VideocardWidget.h"
#include "GlobalFunctions.h"
#include "ChangeEntriesDialog.h"
#include "PropertiesDialog.h"


VideocardWidget :: VideocardWidget(QWidget *Parent, Xorg *Xorg)
    : QWidget( Parent, "Mouse Widget" )
{

X = Xorg;


setGeometry(0, 0, 560, 351);

//Creating pixmap
    KIconLoader *Icons = new KIconLoader();
    QLabel *Pixmap = new QLabel(this);
    Pixmap->setGeometry(422, 10, 128, 128);
    Pixmap->setPixmap(Icons->loadIcon("kcmpci", KIcon::Desktop, KIcon::SizeEnormous));

//Information Label
   QLabel *InformationLabel = new QLabel(this);
    InformationLabel->setText(Locale(0));
    InformationLabel->setFont(QFont("sans", 19, QFont::Normal, FALSE));
    InformationLabel->setGeometry(10, 10, 400, 25);
//Horizontal Line
   QFrame *Line = new QFrame(this);
    Line->setGeometry(QRect(10, 45, 400, 5));
    Line->setFrameShape( QFrame::HLine );
    Line->setFrameShadow( QFrame::Sunken );
//Layouts Combo Box
   VideoCombo = new KComboBox(this);
    VideoCombo->setGeometry(10, 55, 400, 25);
//Change Name Button
   KPushButton *ChangeNameButton = new KPushButton(this);
    ChangeNameButton->setText(Locale(1));
    ChangeNameButton->setGeometry(270, 90, 140, 25);
    ChangeNameButton->setIconSet(Icons->loadIcon("edit", KIcon::Toolbar, KIcon::SizeSmall));
//Advanced settings button
   KPushButton *AdvancedSettingsButton = new KPushButton(this);
    AdvancedSettingsButton->setText(Locale(2));
    AdvancedSettingsButton->setGeometry(10, 313, 140, 25);
    AdvancedSettingsButton->setIconSet(Icons->loadIcon("configure", KIcon::Toolbar, KIcon::SizeSmall));
//Driver label
   QLabel *DriverLabel = new QLabel(this);
    DriverLabel->setText(Locale(3));
    DriverLabel->setGeometry(10, 130, 260, 25);
//Driver combo
   DriverCombo = new KComboBox(this);
    DriverCombo->setGeometry(10, 155, 260, 25);

//Device label
   QLabel *VendorNameLabel = new QLabel(this);
    VendorNameLabel->setText(Locale(4));
    VendorNameLabel->setGeometry(10, 190, 260, 25);
//Device URL
   VendorNameLineEdit = new KLineEdit(this);
    VendorNameLineEdit->setGeometry(10, 215, 260, 25);





//Group Box
   QGroupBox *Group = new QGroupBox(this);
    Group->setGeometry(280, 140, 280, 198);
    Group->setTitle(Locale(5));
//Driver info
   DriverInfoLabel = new QLabel(Group);
    DriverInfoLabel->setGeometry(10, 20, 260, 168);
    DriverInfoLabel->setAlignment(QLabel::WordBreak | QLabel::AlignTop);

//Filling drivers combo

QString PathToVideoDrivers = X->GetProperty(Xorg::PathToVideoDrv);


if (QFile::exists(PathToVideoDrivers + "apm_drv.so"))             { DriverCombo->insertItem("apm"); }
if (QFile::exists(PathToVideoDrivers + "ark_drv.so"))             { DriverCombo->insertItem("ark"); }
if (QFile::exists(PathToVideoDrivers + "ati_drv.so"))             { DriverCombo->insertItem("ati"); }
if (QFile::exists(PathToVideoDrivers + "atimisc_drv.so"))         { DriverCombo->insertItem("atimisc"); }
if (QFile::exists(PathToVideoDrivers + "chips_drv.so"))           { DriverCombo->insertItem("chips"); }
if (QFile::exists(PathToVideoDrivers + "cirrus_drv.so"))          { DriverCombo->insertItem("cirrus"); }
if (QFile::exists(PathToVideoDrivers + "cyrix_drv.so"))           { DriverCombo->insertItem("cyrix"); }
if (QFile::exists(PathToVideoDrivers + "dummy_drv.so"))           { DriverCombo->insertItem("dummy"); }
if (QFile::exists(PathToVideoDrivers + "fbdev_drv.so"))           { DriverCombo->insertItem("fbdev"); }
if (QFile::exists(PathToVideoDrivers + "glint_drv.so"))           { DriverCombo->insertItem("glint"); }
if (QFile::exists(PathToVideoDrivers + "i128_drv.so"))            { DriverCombo->insertItem("i128"); }
if (QFile::exists(PathToVideoDrivers + "i740_drv.so"))            { DriverCombo->insertItem("i740"); }
if (QFile::exists(PathToVideoDrivers + "i810_drv.so"))            { DriverCombo->insertItem("i810"); }
if (QFile::exists(PathToVideoDrivers + "mga_drv.so"))             { DriverCombo->insertItem("mga"); }
if (QFile::exists(PathToVideoDrivers + "neomagic_drv.so"))        { DriverCombo->insertItem("neomagic"); }
if (QFile::exists(PathToVideoDrivers + "nsc_drv.so"))             { DriverCombo->insertItem("nsc"); }
if (QFile::exists(PathToVideoDrivers + "nv_drv.so"))              { DriverCombo->insertItem("nv"); }
if (QFile::exists(PathToVideoDrivers + "nvidia_drv.so"))          { DriverCombo->insertItem("nvidia"); }
else
{ if (QFile::exists(PathToVideoDrivers + "nvidia_drv.o"))           { DriverCombo->insertItem("nvidia"); } }


if (QFile::exists(PathToVideoDrivers + "r128_drv.so"))            { DriverCombo->insertItem("r128"); }
if (QFile::exists(PathToVideoDrivers + "radeon_drv.so"))          { DriverCombo->insertItem("radeon"); }
if (QFile::exists(PathToVideoDrivers + "rendition_drv.so"))       { DriverCombo->insertItem("rendition"); }
if (QFile::exists(PathToVideoDrivers + "riva128.so"))             { DriverCombo->insertItem("riva128"); }
if (QFile::exists(PathToVideoDrivers + "s3_drv.so"))              { DriverCombo->insertItem("s3"); }
if (QFile::exists(PathToVideoDrivers + "s3virge_drv.so"))         { DriverCombo->insertItem("s3virge"); }
if (QFile::exists(PathToVideoDrivers + "savage_drv.so"))          { DriverCombo->insertItem("savage"); }
if (QFile::exists(PathToVideoDrivers + "siliconmotion_drv.so"))   { DriverCombo->insertItem("siliconmotion"); }
if (QFile::exists(PathToVideoDrivers + "sis_drv.so"))             { DriverCombo->insertItem("sis"); }
if (QFile::exists(PathToVideoDrivers + "sisusb_drv.so"))          { DriverCombo->insertItem("sisusb"); }
if (QFile::exists(PathToVideoDrivers + "tdfx_drv.so"))            { DriverCombo->insertItem("tdfx"); }
if (QFile::exists(PathToVideoDrivers + "trident_drv.so"))         { DriverCombo->insertItem("trident"); }
if (QFile::exists(PathToVideoDrivers + "tseng_drv.so"))           { DriverCombo->insertItem("tseng"); }
if (QFile::exists(PathToVideoDrivers + "vesa_drv.so"))            { DriverCombo->insertItem("vesa"); }
if (QFile::exists(PathToVideoDrivers + "vga_drv.so"))            { DriverCombo->insertItem("vga"); }
if (QFile::exists(PathToVideoDrivers + "via_drv.so"))            { DriverCombo->insertItem("via"); }
if (QFile::exists(PathToVideoDrivers + "vmware_drv.so"))         { DriverCombo->insertItem("vmware"); }
if (QFile::exists(PathToVideoDrivers + "voodoo_drv.so"))         { DriverCombo->insertItem("voodoo"); }






connect (VideoCombo, SIGNAL(activated(int)), this, SLOT(Init()));
connect (DriverCombo, SIGNAL(activated(int)), this, SLOT(SaveDriver()));
connect (DriverCombo, SIGNAL(activated(int)), this, SLOT(DriverComboCheck()));
connect (VendorNameLineEdit, SIGNAL(textChanged(const QString&)), this, SLOT(SaveVendorName()));
connect (ChangeNameButton, SIGNAL(clicked()), this, SLOT(ChangeEntries()));
connect (AdvancedSettingsButton, SIGNAL(clicked()), this, SLOT(AdvancedSettings()));

RefreshVideoCombo();
Init();
ShowDriverDescription();

}


void VideocardWidget :: RefreshVideoCombo()
{
   VideoCombo->clear();
   for (int a = 1; a <= X->CountSections(Xorg::Device); a++)
    {
     VideoCombo->insertItem(X->GetValue(Xorg::Device, a, "Identifier", 1)); 
    }

}

void VideocardWidget :: DriverComboCheck()
{

X->ClearOptions(Xorg::Device, VideoCombo->currentItem() + 1);

ShowDriverDescription();
}

void VideocardWidget :: Init()
{
QString CurrentDriver = X->GetValue(Xorg::Device, VideoCombo->currentItem() + 1, "Driver", 1);

  for (int a = 0; a < DriverCombo->count(); a++)
   {
    if (DriverCombo->text(a) == CurrentDriver) { DriverCombo->setCurrentItem(a); break; }
   }

VendorNameLineEdit->setText(X->GetValue(Xorg::Device, VideoCombo->currentItem() + 1, "VendorName", 1));
}

void VideocardWidget :: SaveDriver()
{
X->WriteValue(Xorg::Device, VideoCombo->currentItem() + 1, "Driver", DriverCombo->text(DriverCombo->currentItem()));
}

void VideocardWidget :: SaveVendorName()
{
X->WriteValue(Xorg::Device, VideoCombo->currentItem() + 1, "VendorName", VendorNameLineEdit->text());
}

void VideocardWidget :: ShowDriverDescription()
{
GlobalFunctions Global;
DriverInfoLabel->setText(Global.GetVideoDescription(DriverCombo->text(DriverCombo->currentItem())));
}


void VideocardWidget :: ChangeEntries()
{
ChangeEntriesDialog *Change = new ChangeEntriesDialog(this, X, ChangeEntriesDialog::Device);
Change->exec();
RefreshVideoCombo();
Init();
}

void VideocardWidget :: AdvancedSettings()
{
PropertiesDialog *Video = new PropertiesDialog();

QString Driver = DriverCombo->text(DriverCombo->currentItem());

if (Driver == "nv") { Video->SetOptions_NV(this, X, VideoCombo->currentItem() +1); return; }
if (Driver == "nvidia") { Video->SetOptions_NVIDIA(this, X, VideoCombo->currentItem() +1); return; }
if (Driver == "vesa") { Video->SetOptions_VESA(this, X, VideoCombo->currentItem() +1); return; }
if (Driver == "dummy") { Video->NoOptions(Driver); return; }
if (Driver == "vga") { Video->SetOptions_VGA(this, X, VideoCombo->currentItem() +1); return; }
if (Driver == "i128") { Video->SetOptions_i128(this, X, VideoCombo->currentItem() +1); return; }
if (Driver == "i740") { Video->NoOptions(Driver); return; }
if (Driver == "i810") { Video->SetOptions_i810(this, X, VideoCombo->currentItem() +1); return; }






KMessageBox::error(this, Locale(7).arg(Driver), Locale(6));
return;
}
