/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "albumdialog.h"

albumdialog::albumdialog(QScrollView *pointer,compactdisc *cd)
{
  if (cd)
    {
      counter=cd->cdcontent->trackcount;
      if (!counter)
        {
          nothing=new QLabel(i18n("<center><b>press refresh cd-info to read in cd-contents</b></center>"),pointer->viewport());
          pointer->addChild(nothing,0,0);
          pointer->resizeContents(600,50);
          pointer->setResizePolicy(QScrollView::AutoOneFit);
        }
      else
        {
          scrollbox=new QGroupBox(4,Qt::Horizontal,pointer->viewport());
          pointer->addChild(scrollbox,0,0);
          pointer->resizeContents(600,200);
          pointer->setResizePolicy(QScrollView::AutoOneFit);
          songfield=new song *[counter];
          timefield=new long [counter];
          for (int i=0;i<counter;i++)
            {
              if (cd->cdcontent->cdtoc[i].mode==4)
                {
                  //Grey out all data-tracks
                  timefield[i]=cd->cdcontent->cdtoc[i+1].frameoffset-cd->cdcontent->cdtoc[i].frameoffset;
                  songfield[i]=new song(scrollbox,timefield[i]);
                }
              else
                {
                  timefield[i]=cd->cdcontent->cdtoc[i+1].frameoffset-cd->cdcontent->cdtoc[i].frameoffset;
                  songfield[i]=new song(scrollbox,i+1,timefield[i]);
                }
            }
        }
    }
  else
    {
      counter=0;
      nothing=new QLabel(i18n("<center><b>press refresh cd-info to read in cd-contents</b></center>"),pointer->viewport());
      pointer->addChild(nothing,0,0);
      pointer->resizeContents(600,50);
      pointer->setResizePolicy(QScrollView::AutoOneFit);
    }
}

albumdialog::~albumdialog()
{
  cerr<<"albumdialog destructor"<<endl;
  if (!counter)
    {
      delete nothing;
    }
  else
    {
      for (int i=1;i<=counter;i++)
        {
          delete songfield[i-1];
        }
      delete songfield;
      delete timefield;
      delete scrollbox;
    }
}

void albumdialog::setalltracks(QStringList *songlist)
{
  int filledcounter=0;
  QStringList::Iterator index=songlist->begin();
  while(index!=songlist->end()and filledcounter<counter)
    {
      songfield[filledcounter]->songledit->setText(*index);
      index++;
      filledcounter++;
    }

}

song::song(QWidget *pointer,int index,long duration)
{
  QString labelstring=QString(i18n("Song "));
  if (index<10)
    labelstring=QString("%10").arg(labelstring);
  labelstring=QString("%1%2").arg(labelstring,QString::number(index));
  songlabel=new QLabel(labelstring,pointer);
  songcheck=new QCheckBox(pointer);
  songledit=new QLineEdit(pointer);
  QString songtimestring;
  int minutes=duration/4500;
  int seconds=(duration-(minutes*4500))/75;
  if (minutes<10)
    songtimestring=QString("0");
  songtimestring=QString("%1%2min:").arg(songtimestring,QString::number(minutes));
  if (seconds<10)
    songtimestring=QString("%10").arg(songtimestring);
  songtimestring=QString("%1%2sec").arg(songtimestring,QString::number(seconds));
  songtime=new QLabel(songtimestring,pointer);
}

song::song(QGroupBox *pointer,long duration)
{
  songcheck=NULL;
  songtime=NULL;
  QString labelstring=QString(i18n("Datatrack "));
  songlabel=new QLabel(labelstring,pointer);
  songcheck=new QCheckBox(pointer);
  songcheck->setDisabled(TRUE);
  songledit=new QLineEdit(pointer);
  songledit->setDisabled(TRUE);
  QString songtimestring;
  int minutes=duration/4500;
  int seconds=(duration-(minutes*4500))/75;
  if (minutes<10)
    songtimestring=QString("0");
  songtimestring=QString("%1%2min:").arg(songtimestring,QString::number(minutes));
  if (seconds<10)
    songtimestring=QString("%10").arg(songtimestring);
  songtimestring=QString("%1%2sec").arg(songtimestring,QString::number(seconds));
  songtime=new QLabel(songtimestring,pointer);
}

song::~song()
{
  cerr<<"song destructor"<<endl;
  delete songlabel;
  delete songcheck;
  delete songledit;
  delete songtime;
}



