/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

using namespace std;

#ifndef _TABLEISTE_H_
#define _TABLEISTE_H_


#include <iostream>

#include <qstring.h>
#include <qcstring.h>
#include <qlabel.h>
#include <qvbox.h>
#include <qtabdialog.h>
#include <qpixmap.h>
#include <qdragobject.h>
#include <klocale.h>
#include <kiconloader.h>
#include <qfileinfo.h>
#include <qfile.h>

#include "tagdialog.h"
#include "settingsmaindialog.h"
#include "aboutdialog.h"
#include "ripper.h"
#include "rcdatei.h"

class tagdialog;
class settingsmaindialog;
class aboutdialog;
class ripperdialog;

class tableiste : public QTabDialog
  {
    Q_OBJECT
  protected:
    void dropEvent(QDropEvent *);
    void dragEnterEvent(QDragEnterEvent *);
  public:
    tableiste();
    ~tableiste();
    void initapplication();
    KIconLoader *loader;
    QVBox *tagger;
    QVBox *ripper;
    QVBox *settings;
    QVBox *about;
    tagdialog *tagmask;
    ripperdialog *rippermask;
    settingsmaindialog *settingsmask;
    aboutdialog *aboutmask;
  public slots:
    void closeEvent(QCloseEvent *);
  signals:
    void gotImage(QImage);
  };

#endif // _TABLEISTE_H_
