/***************************************************************************
 *
 *  $Id: kzenartist.h,v 1.8 2005/05/31 06:54:02 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENARTIST_H
#define KZENARTIST_H

#include <qptrlist.h>
#include <qstring.h>

#include "kzenitem.h"

class QPainter;

class KZenTrack;
class KZenAlbum;
class KZenArtistItem;

/**
@author Andreas Mussgiller
*/
class KZenArtist
{

 public:
 
  KZenArtist(const char * name);
  ~KZenArtist();

  const char *                getName() { return fName; }
  void                        setName(const char * name);

  void                        addTrack(KZenTrack *);
  QPtrList<KZenTrack> *       getTrackList() { return fTracks; }

  QPtrList<KZenAlbum> *       getAlbumList() { return fAlbums; }

  KZenArtistItem *            getItem() { return fItem; }
  void                        setItem(KZenArtistItem * i) { fItem = i; }

  static QStringList &        getArtists();

  uint                        getTrackCount();
  uint                        getAlbumCount();
  uint                        getLength();

 protected:

  QString                     fName;
  QPtrList<KZenTrack> *       fTracks;
  QPtrList<KZenAlbum> *       fAlbums;

  static QStringList          fArtists;

  KZenArtistItem             *fItem;
};

class KZenArtistItem : public KZenItem
{
 public:

  KZenArtistItem(QListView * parent, KZenArtist * Artist);
  ~KZenArtistItem();

  KZenArtist *                getArtist() { return fArtist; }

  void                        paintCell(QPainter*, const QColorGroup&, int, int, int);

 protected:

  KZenArtist                 *fArtist;
};

#endif
