/***************************************************************************
 *
 *  $Id: kzenitem.h,v 1.10 2005/05/31 07:18:20 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENITEM_H
#define KZENITEM_H

#include <qptrlist.h>

#include <klistview.h>

#include "kzenglobal.h"
#include "kzentrack.h"

/**
@author Andreas Mussgiller
*/
class KZenItem : public KListViewItem
{
 public:
  
  enum ItemType {
    ItemTypeArtist = 0,
    ItemTypeAlbum,
    ItemTypeAlbumTL,
    ItemTypeGenre,
    ItemTypePlayList,
    ItemTypeSmartPlayList,
    ItemTypeUnknown
  };
  
  virtual ~KZenItem();
  
  ItemType                    getItemType() { return fItemType; }
  ItemType                    getItemType() const { return fItemType; }
  
  KZen::TagField              getSortColumn() { return fSortColumn; }
  virtual void                setSortColumn(KZen::TagField s) { fSortColumn = s; }
  Qt::SortOrder               getSortOrder() { return fSortOrder; }
  virtual void                setSortOrder(Qt::SortOrder o) { fSortOrder = o; }

  int                         compare(QListViewItem * i, int col, bool ascending) const;
  
  virtual void                triggerUpdate();
  
 protected:

  KZenItem(QListView * parent, ItemType type = ItemTypeUnknown);
  KZenItem(QListViewItem * parent, ItemType type = ItemTypeUnknown);
  
  ItemType                    fItemType;

  KZen::TagField              fSortColumn;
  Qt::SortOrder               fSortOrder;
};

#endif
