//LabPlot : InterpolationListDialog.h

#ifndef INTERPOLATIONLISTDIALOG_H
#define INTERPOLATIONLISTDIALOG_H

#include "ListDialog.h"

class InterpolationListDialog : public ListDialog
{
	Q_OBJECT
public:
	InterpolationListDialog(MainWin *mw, const char *name);
public slots:
	void setType(int type) {typecb->setCurrentItem(type); }		//!< set type of interpolation
	void setRange(double a, double b) {						//!< set range for interpolation
		ale->setText(QString::number(a)); ble->setText(QString::number(b)); }
	void setFrom(double v) { ale->setText(QString::number(v)); }
	void setTo(double v) { ble->setText(QString::number(v)); }
	void setNumber(int nr) { nrni->setValue(nr); }			//!< set number of interpolating points
	void setSorted(bool b=true) { sorted->setChecked(b); }		//!< sort and uniq points
	int Apply() { return apply_clicked(); }
private:
	KComboBox *typecb;
	KIntNumInput *nrni;
	QCheckBox *sorted;
private slots:
	void saveSettings();
	int apply_clicked();
};

#endif // INTERPOLATIONLISTDIALOG_H
