//LabPlot : ObjectDialog.h

#ifndef OBJECTDIALOG_H
#define OBJECTDIALOG_H

#include <qfont.h>
#include <qcheckbox.h>
#include <qlistview.h>
#include "Worksheet.h"
#include "Dialog.h"
#include "RichTextWidget.h"

class ObjectDialog: public Dialog
{
	Q_OBJECT
public:
	ObjectDialog(MainWin *mw, const char *name, int activetab, int item);
	void updateDialog();
public slots:
	void setType(int t) { tw->setCurrentPage(t); }
	int Type() { return tw->currentPageIndex(); }
	// TODO : select item
	void setItem(int i) {
		switch(tw->currentPageIndex()) {
		case 1: lv1->setSelected(lv1->itemAt(QPoint(0,i*lv1->currentItem()->height())),true); break;
		case 2: lv2->setSelected(lv2->itemAt(QPoint(0,i*lv2->currentItem()->height())),true); break;
		case 3: lv3->setSelected(lv3->itemAt(QPoint(0,i*lv3->currentItem()->height())),true); break;
		case 4: lv4->setSelected(lv4->itemAt(QPoint(0,i*lv4->currentItem()->height())),true); break;
		case 5: lv5->setSelected(lv5->itemAt(QPoint(0,i*lv5->currentItem()->height())),true); break;
		} 
	}
	int Item() { 
		switch(tw->currentPageIndex()) {
		case 1: return (int) (lv1->itemPos(lv1->currentItem())/lv1->currentItem()->height());
		case 2: return (int) (lv2->itemPos(lv2->currentItem())/lv2->currentItem()->height());
		case 3: return (int) (lv3->itemPos(lv3->currentItem())/lv3->currentItem()->height());
		case 4: return (int) (lv4->itemPos(lv4->currentItem())/lv4->currentItem()->height());
		case 5: return (int) (lv5->itemPos(lv5->currentItem())/lv5->currentItem()->height());
		}
		return 0;
	}
	void deleteObject();

	void setLineStartPoint(double x, double y) 
		{ lx1le->setText(QString::number(x)); ly1le->setText(QString::number(y)); }
	Point LineStartPoint() { return Point(lx1le->text().toDouble(), ly1le->text().toDouble() ); }
	void setLineEndPoint(double x, double y) 
		{ lx2le->setText(QString::number(x)); ly2le->setText(QString::number(y)); }
	Point LineEndPoint() { return Point(lx2le->text().toDouble(), ly2le->text().toDouble() ); }
	void setLineWidth(int w) { lwni->setValue(w); }
	int LineWidth() { return lwni->value(); }
	void setLineColor(QColor c) { lcb->setColor(c); }
	QColor LineColor() { return lcb->color(); }
	void enableStartArrow(bool e=true) { startcb->setChecked(e); }
	bool StartArrowEnabled() { return startcb->isChecked(); }
	void setStartArrowLength(double l) { salle->setText(QString::number(l)); }
	double StartArrowLength() { return salle->text().toDouble(); }
	void setStartArrowAngle(double l) { saale->setText(QString::number(l)); }
	double StartArrowAngle() { return saale->text().toDouble(); }
	void setStartArrowFilled(bool f=true) { safcb->setChecked(f); }
	bool StartArrowFilled() { return safcb->isChecked(); }
	void setStartArrowFillColor(QColor c) { safccb->setColor(c); }
	QColor StartArrowFillColor() { return safccb->color(); }
	void enableEndArrow(bool e=true) { endcb->setChecked(e); }
	bool EndArrowEnabled() { return endcb->isChecked(); }
	void setEndArrowLength(double l) { ealle->setText(QString::number(l)); }
	double EndArrowLength() { return ealle->text().toDouble(); }
	void setEndArrowAngle(double l) { eaale->setText(QString::number(l)); }
	double EndArrowAngle() { return eaale->text().toDouble(); }
	void setEndArrowFilled(bool f=true) { eafcb->setChecked(f); }
	bool EndArrowFilled() { return eafcb->isChecked(); }
	void setEndArrowFillColor(QColor c) { eafccb->setColor(c); }
	QColor EndArrowFillColor() { return eafccb->color(); }
	
	void setLabel(Label *l) { rtw->setLabel(l); }
	Label *getLabel() { return rtw->getLabel(); }
	
	void setRectPosition(double x, double y) 
		{ rx1le->setText(QString::number(x)); ry1le->setText(QString::number(y)); }
	Point getRectPosition() 
		{ return Point(rx1le->text().toDouble(),ry1le->text().toDouble()); }
	void setRectSize(double x, double y) 
		{ rx2le->setText(QString::number(x)); ry2le->setText(QString::number(y)); }
	Point getRectSize() 
		{ return Point(rx2le->text().toDouble(),ry2le->text().toDouble()); }
	void setRectWidth(int w) { rwni->setValue(w); }
	int RectWidth() { return rwni->value(); }
	void setRectColor(QColor c) { rcb->setColor(c); }
	QColor RectColor() { return rcb->color(); }
	void setRectFilled(bool e=true) { rfccb->setChecked(e); }
	bool RectFilled() { return rfccb->isChecked(); }
	void setRectFillColor(QColor c) { rfcb->setColor(c); }	
	QColor RectFillColor() { return rfcb->color(); }

	void setEllipsePosition(double x, double y) 
		{ ex1le->setText(QString::number(x)); ey1le->setText(QString::number(y)); }
	Point getEllipsePosition() 
		{ return Point(ex1le->text().toDouble(),ey1le->text().toDouble()); }
	void setEllipseSize(double x, double y) 
		{ ex2le->setText(QString::number(x)); ey2le->setText(QString::number(y)); }
	Point getEllipseSize() 
		{ return Point(ex2le->text().toDouble(),ey2le->text().toDouble()); }
	void setEllipseWidth(int w) { ewni->setValue(w); }
	int EllipseWidth() { return ewni->value(); }
	void setEllipseColor(QColor c) { ecb->setColor(c); }
	QColor EllipseColor() { return ecb->color(); }
	void setEllipseFilled(bool e=true) { efccb->setChecked(e); }
	bool EllipseFilled() { return efccb->isChecked(); }
	void setEllipseFillColor(QColor c) { efcb->setColor(c); }	
	QColor EllipseFillColor() { return efcb->color(); }

	void setImagePosition(double x, double y) 
		{ ixle->setText(QString::number(x)); iyle->setText(QString::number(y)); }
	Point ImagePosition()
		{ return Point(ixle->text().toDouble(),iyle->text().toDouble()); }
	void setImageFile(QString n) { ile->setText(n); }
	QString ImageFile() { return ile->text(); }
	void setImageScale(double s) { isle->setText(QString::number(s)); }
	double ImageScale() { return isle->text().toDouble(); }
	void setImageAngle(double a) { iale->setText(QString::number(a)); }
	double ImageAngle() { return iale->text().toDouble(); }

	int Apply() { return apply_clicked(); }
private:
	QTabWidget *tw;
	RichTextWidget *rtw;
	QListView *lv1, *lv2, *lv3, *lv4, *lv5;	// line, label, rect, ellipse, image
	KLineEdit *lx1le, *ly1le, *lx2le, *ly2le;	//line
	KLineEdit *rx1le, *ry1le, *rx2le, *ry2le;	//rect
	KLineEdit *ex1le, *ey1le, *ex2le, *ey2le;	//ellipse
	KLineEdit *ixle, *iyle;				//image
	KIntNumInput *lwni, *rwni, *ewni;
	KLineEdit *ile, *isle, *iale, *salle, *saale, *ealle, *eaale;
	KColorButton *lcb, *rcb, *rfcb, *ecb, *efcb, *safccb, *eafccb;
	QCheckBox *rfccb, *efccb, *startcb, *endcb, *safcb, *eafcb;
	int item;							// current item
private slots:
	void ok_clicked() { apply_clicked(); accept(); }
	void saveSettings();
	int apply_clicked();
	void selectFile();
	void updateLine();
	void updateLineListView();
	void updateLabel();
	void updateLabelListView();
	void updateRect();
	void updateRectListView();
	void updateEllipse();
	void updateEllipseListView();
	void updateImage();
	void updateImageListView();
};

#endif //OBJECTDIALOG_H
