//LabPlot : PeriodicListDialog.h

#ifndef PERIODICLISTDIALOG_H
#define PERIODICLISTDIALOG_H

#include "ListDialog.h"

class PeriodicListDialog : public ListDialog
{
	Q_OBJECT
public:
	PeriodicListDialog(MainWin *mw, const char *name);
public slots:
	void setPeriod(int p) {nni->setValue(p); }			//!< set period number of points
	void setAverage(bool a=true) { averagecb->setChecked(a); }	//!< average over period
	int Apply() { return apply_clicked(); }
private:
	KIntNumInput *nni;
	QCheckBox *averagecb;
private slots:
	void saveSettings();
	int apply_clicked();
};

#endif // PERIODICLISTDIALOG_H
