/*
 *   LADCCA
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCA_CONTROL_H__
#define __LADCCA_CONTROL_H__

#include <ladcca/ladcca.h>
#include <ladcca/list.h>

#include "project.h"

typedef struct _ladcca_control ladcca_control_t;

struct _ladcca_control
{
  cca_client_t * client;
  cca_list_t * projects;
  project_t * cur_project;
};

void ladcca_control_init (ladcca_control_t * control);
void ladcca_control_free (ladcca_control_t * control);

void ladcca_control_main (ladcca_control_t * control);

#endif /* __LADCCA_CONTROL_H__ */
