/*
 *   LADCCA
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCA_ARGS_H__
#define __LADCCA_ARGS_H__

#ifdef __cplusplus
extern "C" {
#endif

#include <uuid/uuid.h>

struct _cca_args
{
  char *  project;
  char *  server;
  uuid_t  id;
  int     flags;
  
  int     argc;
  char ** argv;
};

void cca_args_free (cca_args_t * args);

cca_args_t * cca_args_new ();
void         cca_args_destroy (cca_args_t * args);

void cca_args_set_project (cca_args_t * args, const char * project);
void cca_args_set_server  (cca_args_t * args, const char * server);
void cca_args_set_port    (cca_args_t * args, int port);
void cca_args_set_id      (cca_args_t * args, uuid_t id);
void cca_args_set_flags   (cca_args_t * args, int flags);
void cca_args_set_flag    (cca_args_t * args, int flag);
void cca_args_set_args    (cca_args_t * args, int argc, const char * const * argv);

const char *         cca_args_get_project (const cca_args_t * args);
const char *         cca_args_get_server  (const cca_args_t * args);
int                  cca_args_get_port    (const cca_args_t * args);
void                 cca_args_get_id      (const cca_args_t * args, uuid_t id);
int                  cca_args_get_flags   (const cca_args_t * args);
int                  cca_args_get_argc    (const cca_args_t * args);
char **              cca_args_take_argv   (cca_args_t * args);
const char * const * cca_args_get_argv    (const cca_args_t * args);

#ifdef __cplusplus
}
#endif

#endif /* __LADCCA_ARGS_H__ */
