/*
    ldapdiff
    Copyright (C) 2000-2002 Thomas.Reith@rhoen.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <lber.h>
#include <ldap.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ldapdiff.h"

void ldifstats(struct s_mod *smod)
{
 struct s_mod      *psmod;
 struct s_modentry *psmodentry;
 int                cmodattr = 0;
 int                cmodentr = 0;
 int                cmodaddattr = 0;
 int                caddentr = 0;
 int                caddaddattr = 0;
 int                cdelentr = 0;
 int                cdelattr = 0;

 psmod = smod;

 while(psmod != NULL){
  switch(psmod->modtype){
   case MODADD:
        psmodentry = psmod->attrlist;
        while(psmodentry != NULL){
         caddaddattr++;
         psmodentry = psmodentry->next; 
        }
        caddentr++;
        break;

   case MODMODIFY:
        psmodentry = psmod->attrlist;
        while(psmodentry != NULL){
         switch(psmodentry->modtype){
          case MODENTRYADD:
               cmodaddattr++;
               break;

          case MODENTRYREPLACE:
               cmodattr++;
               break;

          case MODENTRYDELETE:
               cdelattr++;
               break;
         }
         psmodentry = psmodentry->next; 
        }
        cmodentr++;
        break;

   case MODDELETE:
        cdelentr++;
        break;
  } 

  psmod = psmod->next;
 } 

 ldiflog(LOG1,"delta:      %10d modify    entries",cmodentr);
 ldiflog(LOG1,"delta:      %10d - replace attributes",cmodattr);
 ldiflog(LOG1,"delta:      %10d - add     attributes",cmodaddattr);
 ldiflog(LOG1,"delta:      %10d - delete  attributes",cdelattr);
 ldiflog(LOG1,"delta:      %10d add       entries",caddentr);
 ldiflog(LOG1,"delta:      %10d - add     attributes",caddaddattr);
 ldiflog(LOG1,"delta:      %10d delete    entries",cdelentr);
}
