/*
    ldapdiff
    Copyright (C) 2000-2001 Thomas.Reith@rhoen.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <lber.h>
#include <ldap.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ldapdiff.h"

void ldifskeleton(struct s_mod *smod)
{
 struct s_mod      *psmod;
 struct s_modentry *psmodentry;

 psmod = smod;

 while(psmod != NULL){
  switch(psmod->modtype){
   case MODADD:
/*
psmod->dnvar holds the entry name  of the new ldap entry
psmod->dnval holds the entry value of the new ldap entry
*/
        psmodentry = psmod->attrlist;
        while(psmodentry != NULL){
/*
psmodentry->var holds the attribute name  of the new ldap entry
psmodentry->val holds the attribute value of the new ldap entry
psmodentry->val_len holds the attribute value of the new ldap entry 
psmodentry->val_type holds the attribute type of the new ldap entry 
*/
         psmodentry = psmodentry->next; 
        }
        break;

   case MODMODIFY:
        psmodentry = psmod->attrlist;
        while(psmodentry != NULL){
         switch(psmodentry->modtype){
          case MODENTRYADD:
               break;

          case MODENTRYREPLACE:
               break;

          case MODENTRYDELETE:
               break;
         }
         psmodentry = psmodentry->next; 
        }
        break;

   case MODDELETE:
        break;
  } 

  psmod = psmod->next;
 } 
}
