/***************************************************************************
 *   Copyright (C) 2007 by Miguel Chavez Gamboa                            *
 *   miguel.chavez.gamboa@gmail.com                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *

 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#include "squeeze.h"
#include "squeezeview.h"
#include "settings.h"

#include <qapplication.h>
#include <qpainter.h>
#include <QDragEnterEvent>
#include <QDropEvent>
#include <QPrinter>

#include <kdeversion.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <kconfigdialog.h>
//#include <kio/netaccess.h>
// #include <kfiledialog.h>
#include <kactioncollection.h>
#include <kaction.h>
#include <KLocale>
#include <kled.h>

squeeze::squeeze()
    : KXmlGuiWindow( ),
      m_view(new squeezeView(this)),
      m_printer(0)
{
    setObjectName(QLatin1String("squeeze"));
    // accept dnd
    setAcceptDrops(false);

    // tell the KXmlGuiWindow that this is indeed the main widget
    setCentralWidget(m_view);

    // then, setup our actions
    setupActions();
    //Add some widgets to status bar
    led = new KLed;
    led->off();
    connect(m_view, SIGNAL(signalDisconnected()), led, SLOT(off()));
    connect(m_view, SIGNAL(signalConnected()), led, SLOT(on()));
    statusBar()->addWidget(led);
    // add a status bar
    statusBar()->show();

    // Add typical actions and save size/toolbars/statusbar
    setupGUI();
    checkConnection();

    // allow the view to change the statusbar and caption
    connect(m_view, SIGNAL(signalChangeStatusbar(const QString&)),
            this,   SLOT(changeStatusbar(const QString&)));
    connect(m_view, SIGNAL(signalChangeCaption(const QString&)),
            this,   SLOT(changeCaption(const QString&)));
}

squeeze::~squeeze()
{
    delete m_printer;
}

void squeeze::checkConnection()
{
  if ( m_view->isConnected() ) led->on();
}

void squeeze::setupActions()
{
    KStandardAction::quit(qApp, SLOT(quit()), actionCollection());
    KStandardAction::preferences(this, SLOT(optionsPreferences()), actionCollection());

    //My actions
    QAction* loginAction =  actionCollection()->addAction( "login" );
    loginAction->setText(i18n("Login"));
    loginAction->setIcon(KIcon("office-addressbook"));
    loginAction->setShortcut(Qt::CTRL+Qt::Key_L);
    connect(loginAction, SIGNAL(triggered(bool)),m_view, SLOT(login()));

    QAction* prodBrowseAction =  actionCollection()->addAction( "productsBrowse" );
    prodBrowseAction->setText(i18n("Browse products"));
    prodBrowseAction->setIcon(KIcon("lemon-box"));
    prodBrowseAction->setShortcut(Qt::CTRL+Qt::Key_P);
    connect(prodBrowseAction, SIGNAL(triggered(bool)),m_view, SLOT(showProductsPage()));

    QAction* offersBrowseAction =  actionCollection()->addAction( "offersBrowse" );
    offersBrowseAction->setText(i18n("Browse offers"));
    offersBrowseAction->setIcon(KIcon("lemon-money"));
    offersBrowseAction->setShortcut(Qt::CTRL+Qt::Key_O);
    connect(offersBrowseAction, SIGNAL(triggered(bool)),m_view, SLOT(showOffersPage()));

    QAction* usersBrowseAction =  actionCollection()->addAction( "usersBrowse" );
    usersBrowseAction->setText(i18n("Browse users"));
    usersBrowseAction->setIcon(KIcon("lemon-user"));
    usersBrowseAction->setShortcut(Qt::CTRL+Qt::Key_U);
    connect(usersBrowseAction, SIGNAL(triggered(bool)),m_view, SLOT(showUsersPage()));

    QAction* measuresBrowseAction =  actionCollection()->addAction( "measuresBrowse" );
    measuresBrowseAction->setText(i18n("Browse Measures"));
    measuresBrowseAction->setIcon(KIcon("kruler"));
    measuresBrowseAction->setShortcut(Qt::CTRL+Qt::Key_M);
    connect(measuresBrowseAction, SIGNAL(triggered(bool)),m_view, SLOT(showMeasuresPage()));

    QAction* categoriesBrowseAction =  actionCollection()->addAction( "categoriesBrowse" );
    categoriesBrowseAction->setText(i18n("Browse Categories"));
    categoriesBrowseAction->setIcon(KIcon("lemon-box"));//TODO:Create an icon for this...
    categoriesBrowseAction->setShortcut(Qt::CTRL+Qt::Key_C);
    connect(categoriesBrowseAction, SIGNAL(triggered(bool)),m_view, SLOT(showCategoriesPage()));

    QAction* balancesBrowseAction =  actionCollection()->addAction( "balancesBrowse" );
    balancesBrowseAction->setText(i18n("Browse Balances"));
    balancesBrowseAction->setIcon(KIcon("lemon-box"));//TODO:Create an icon for this...
    balancesBrowseAction->setShortcut(Qt::CTRL+Qt::Key_B);
    connect(balancesBrowseAction, SIGNAL(triggered(bool)),m_view, SLOT(showBalancesPage()));

    QAction* transactionsBrowseAction =  actionCollection()->addAction( "transacionsBrowse" );
    transactionsBrowseAction->setText(i18n("Browse Transactions"));
    transactionsBrowseAction->setIcon(KIcon("lemon-money"));//TODO:Create an icon for this...
    transactionsBrowseAction->setShortcut(Qt::CTRL+Qt::Key_T);
    connect(transactionsBrowseAction, SIGNAL(triggered(bool)),m_view, SLOT(showTransactionsPage()));

    QAction* clientsBrowseAction =  actionCollection()->addAction( "clientsBrowse" );
    clientsBrowseAction->setText(i18n("Browse Clients"));
    clientsBrowseAction->setIcon(KIcon("lemon-user"));//TODO:Create an icon for this...
    clientsBrowseAction->setShortcut(Qt::CTRL+Qt::Key_L);
    connect(clientsBrowseAction, SIGNAL(triggered(bool)),m_view, SLOT(showClientsPage()));

    QAction* purchaseAction =  actionCollection()->addAction( "doPurchase" );
    purchaseAction->setText(i18n("Purchase"));
    purchaseAction->setIcon(KIcon("lemon-money"));//TODO:Create an icon for this...
    purchaseAction->setShortcut(Qt::CTRL+Qt::Key_L);
    connect(purchaseAction, SIGNAL(triggered(bool)),m_view, SLOT(doPurchase()));

//     QAction* prodDeleteAction=  actionCollection()->addAction( "productDel" );
//     prodDeleteAction->setText(i18n("Delete product"));
//     prodDeleteAction->setIcon(KIcon("eraser"));
//     prodDeleteAction->setShortcut(Qt::CTRL+Qt::Key_D);
//     connect(prodDeleteAction, SIGNAL(triggered(bool)),m_view, SLOT(deleteProduct()));

//     QAction* prodHideFilterBoxAction=  actionCollection()->addAction( "hideProductFilterBox" );
//     prodHideFilterBoxAction->setCheckable(true);
//     prodHideFilterBoxAction->setText(i18n("Filter"));
//     prodHideFilterBoxAction->setIcon(KIcon("search-filter"));
//     connect(prodHideFilterBoxAction, SIGNAL(toggled(bool)),m_view, SLOT(toggleFilterBox(bool)));

//     QAction* prodAddAction =  actionCollection()->addAction( "productAdd" );
//     prodAddAction->setText(i18n("Add product"));
//     prodAddAction->setIcon(KIcon("plus"));
//     prodAddAction->setShortcut(Qt::CTRL+Qt::Key_A);
//     connect(prodAddAction, SIGNAL(triggered(bool)),m_view, SLOT(insertProduct()));
}

void squeeze::saveProperties(KConfigGroup &config)
{
    // the 'config' object points to the session managed
    // config file.  anything you write here will be available
    // later when this app is restored

//     if (!m_view->currentURL().isNull()) {
//         config.writePathEntry("lastURL", m_view->currentURL());
//     }
}

void squeeze::readProperties(const KConfigGroup &config)
{
    // the 'config' object points to the session managed
    // config file.  this function is automatically called whenever
    // the app is being restored.  read in here whatever you wrote
    // in 'saveProperties'

//     QString url = config.readPathEntry("lastURL", QString());
//
//     if (!url.isEmpty())
//         m_view->openURL(KUrl::fromPathOrUrl(url));
}


void squeeze::optionsPreferences()
{
    //avoid to have 2 dialogs shown
    if ( KConfigDialog::showDialog( "settings" ) )  {
        return;
    }
    KConfigDialog *dialog = new KConfigDialog(this, "settings", Settings::self());

    //general
    QWidget *generalSettingsDlg = new QWidget;
    ui_prefs_base.setupUi(generalSettingsDlg);
    dialog->addPage(generalSettingsDlg, i18n("General"), "package_setting");
    //Database
    QWidget *dbSettingsDlg = new QWidget;
    ui_prefs_db.setupUi(dbSettingsDlg);
    dialog->addPage(dbSettingsDlg, i18n("Database"), "folder-tar");

    connect(dialog, SIGNAL(settingsChanged(QString)), m_view, SLOT(settingsChanged()));
    //free mem by deleting the dialog on close without waiting for deletingit when the application quits
    dialog->setAttribute( Qt::WA_DeleteOnClose );

    dialog->show();
}

void squeeze::changeStatusbar(const QString& text)
{
    // display the text on the statusbar
    statusBar()->showMessage(text);
}

void squeeze::changeCaption(const QString& text)
{
    // display the text on the caption
    setCaption(text);
}

bool squeeze::queryClose()
{
  m_view->closeDB();
  return true;
}

#include "squeeze.moc"
