/* $Id: hig-widgets.c,v 1.1 2005/03/28 12:51:58 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "hig-widgets.h"

GtkWidget*
hig_window_new (const gchar *title)
{
     GtkWidget *window;

     window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
     gtk_window_set_title (GTK_WINDOW (window), title);
     gtk_container_set_border_width (GTK_CONTAINER (window), WIDGET_BORDER);

     return window;
}

GtkWidget*
hig_hbox_new (void)
{
     GtkWidget *box;
     
     box = gtk_hbox_new (FALSE, BOX_SPACING);
     gtk_container_set_border_width (GTK_CONTAINER (box), WIDGET_BORDER);
     return box;
}

GtkWidget*
hig_vbox_new (void)
{
     GtkWidget *box;
     
     box = gtk_vbox_new (FALSE, BOX_SPACING);
     gtk_container_set_border_width (GTK_CONTAINER (box), WIDGET_BORDER);
     return box;

}

GtkWidget*
hig_frame_new (const gchar *label)
{
     GtkWidget *frame;
     GtkWidget *align;
     GtkWidget *lbl;

     gchar *text = NULL;

     frame = gtk_frame_new (NULL);
     gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);
     gtk_container_set_border_width (GTK_CONTAINER (frame), WIDGET_BORDER);

     text = g_strdup_printf (MARKUP_BOLD, label);
     lbl = gtk_label_new (NULL);
     gtk_label_set_markup (GTK_LABEL (lbl), text);
     gtk_frame_set_label_widget (GTK_FRAME (frame), lbl);
     g_free (text);

     align = gtk_alignment_new (0.5, 0.5, 1, 1);
     gtk_alignment_set_padding (GTK_ALIGNMENT (align), 6, 0, 18, 0);
     gtk_container_add (GTK_CONTAINER (frame), align);


     return frame;
}

GtkWidget*
hig_table_new (guint rows, guint columns)
{
     GtkWidget *table;
     
     table = gtk_table_new (rows, columns, FALSE);
     gtk_container_set_border_width (GTK_CONTAINER (table), WIDGET_BORDER);
     gtk_table_set_row_spacings (GTK_TABLE (table), TBL_ROW_SPACING);
     gtk_table_set_col_spacings (GTK_TABLE (table), TBL_COL_SPACING);

     return table;
}

GtkWidget*
hig_scrolled_window_new (void)
{
     GtkWidget *window;

     window = gtk_scrolled_window_new (NULL, NULL);
     gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (window),
                                          GTK_SHADOW_ETCHED_IN);
     gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (window),
                                     GTK_POLICY_AUTOMATIC,
                                     GTK_POLICY_AUTOMATIC);
     gtk_container_set_border_width (GTK_CONTAINER (window), WIDGET_BORDER);
     return window;
}
