/* $Id: gtkdefs.h,v 1.9 2005/03/28 12:51:58 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LING_GTKDEFS_H
#define LING_GTKDEFS_H 1

#include <gtk/gtk.h>

#include "../event.h"

typedef struct
{
     GtkWidget      *window;        /* editor window */
     GtkUIManager   *menu;          /* editor main menu */
     GtkActionGroup *actions;       /* action group of the menu */
     GtkAccelGroup  *accels;        /* accelerator group for the editor */
     GtkWidget      *status;        /* status bar of the editor */
     GtkWidget      *toolbar;       /* toolbar of the editor */
     GtkWidget      *view_lesson;   /* tree view of the lessons */
     GtkWidget      *view_meanings; /* tree view of the meanings */
} lingGtkEditor;

typedef struct
{
     GtkWidget      *window;   /* the main window */
     GtkUIManager   *menu;     /* the main menu located in the window */
     GtkActionGroup *actions;  /* the action group of the menu */
     GtkAccelGroup  *accels;   /* global accelerator group for the window */
     GtkTooltips    *tips;     /* global Tooltips for the window */
     GtkWidget      *status;   /* status bar of the window */
     GtkWidget      *notebook; /* main notebook for displaying */
     GSList         *pages;    /* page ids for switching */
     Listener       *objects;  /* object queue for events */

     lingGtkEditor  *editor;   /* pointer to the editor structure */
} lingGtkMainWindow;

typedef enum
{
     PAGE_INIT = 0,
     PAGE_LEARN,
     PAGE_TRAIN,
     TOTAL_PAGES
} lingGtkPages;

#endif /* LING_GTKDEFS_H */
