/******************************************************************************
 *   Copyright (C) 2005 by la9527                                             *
 *                                                                            *
 *  This program is free software; you can redistribute it and/or modify      * 
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  This program is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with this program; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.*
 ******************************************************************************/

#include "drawset.h"
#include "ncurses_dialog.h"

using namespace MLSUTIL;

namespace MLS
{

chtype HLINE=ACS_HLINE;		///< 가로 그래픽 문자 '-'
chtype VLINE=ACS_VLINE;		///< 세로 그래픽 문자 '|'
chtype ULCORNER=ACS_ULCORNER;	///< 왼쪽 위 사각 귀뚱이 그래픽 문자
chtype LLCORNER=ACS_LLCORNER;	///< 왼쪽 아래 사각 귀뚱이 그래픽 문자
chtype URCORNER=ACS_URCORNER;	///< 오른쪽 위 사각 귀뚱이 그래픽 문자
chtype LRCORNER=ACS_LRCORNER;	///< 오른쪽 아래 사각 귀뚱이 그래픽 문자
chtype LTEE=ACS_LTEE;			///< ?????
chtype RTEE=ACS_RTEE;			///< ?????
chtype BTEE=ACS_BTEE;			///< 'ㅗ'그래픽 문자
chtype TTEE=ACS_TTEE;			///< 'ㅜ'그래픽 문자

LINECODE	e_nBoxLineCode = ACSLINE;	///< BOX LINE MODE

static Curses_Dialog*		s_pDialog;
static Curses_Progress*		s_pProgressBox;

/// @brief	그래픽모드 라인이나 ASCII모드 라인을 설정한다.
void Set_BoxLine(
		LINECODE nCode			///< 그래픽모드, ASCII모드
	)
{
	switch(nCode)
	{
		case CHARLINE:
			HLINE='-';
			VLINE='|';
			ULCORNER='+';
			LLCORNER='+';
			URCORNER='+';
			LRCORNER='+';
			LTEE='+';
			RTEE='+';
			BTEE='+';
			TTEE='+';
			e_nBoxLineCode = CHARLINE;
			break;

		case ACSLINE:
			HLINE=ACS_HLINE;
			VLINE=ACS_VLINE;
			ULCORNER=ACS_ULCORNER;
			LLCORNER=ACS_LLCORNER;
			URCORNER=ACS_URCORNER;
			LRCORNER=ACS_LRCORNER;
			LTEE=ACS_LTEE;
			RTEE=ACS_RTEE;
			BTEE=ACS_BTEE;
			TTEE=ACS_TTEE;
			e_nBoxLineCode = ACSLINE;
	}
}

/// @brief		consol 초기화 작업.
void CursesInit()
{
	initscr();     // nCurses 시작
	start_color(); // 컬러 가능하게

	nonl();        // 엔터 처리?
	raw();		   // Ctrl+C : Signal무시 가능하게
	//cbreak();      // nCurses : 즉시 입력이 가능하도록 설정

	noecho();	   // nCurses : echo모드 해제
	keypad(stdscr, TRUE);  // keypad 활성화

	curs_set(0); // 커서를 보이지 않게 한다.

	use_default_colors();
	assume_default_colors(-1, -1);
	
	// 색깔 쌍을 초기화 한다. 디폴트 포함 0 ~ 64개 까지
	for (int t=0; t<8; t++)
		for (int t2=0; t2<8; t2++)
	{
		if (t==-1 && t2==-1) continue;
		init_pair(t*8+t2, t, t2);
	}

	/*
	// 디폴트 백그라운드를 위한 내용 (투명콘솔)
	for (int t=0; t<8; t++)
		init_pair(70+t, t, -1);

	// 디폴트 포그라운드를 위한 내용 (투명콘솔)
	for (int t=0; t<8; t++)
		init_pair(80+t, -1, t);
	*/

	// line 설정
	Set_BoxLine(e_nBoxLineCode);

	// 처음 시작할 경우 clear, refresh 해줘야 한다.
	clear();
	refresh();

	ESCDELAY = 10;  // ESC 딜레이 줄이기.

	s_pDialog = new Curses_Dialog;
	s_pProgressBox = new Curses_Progress;

	// Dialog, Progress를 ncurses로 변경
	MLSUTIL::SetDialogProgress( (MlsDialog*)s_pDialog , (MlsProgress*)s_pProgressBox );
}

void CursesDestroy()
{
	if (s_pDialog) delete s_pDialog; 
	if (s_pProgressBox) delete s_pProgressBox;
	s_pDialog = NULL;
	s_pProgressBox = NULL;
	
	clear();
	refresh();

	// . keypad 비활성화
	keypad(stdscr, FALSE);  // . 라인단위로 입력이 이루어지도록 설정
	//nocbreak();
	noraw();
	curs_set(1); // 커서를 다시 보이게 한다.
	noecho();
	endwin();   // . nCurses 해제
}

void	MouseInit()
{
	// curses 마우스 설정
	
	mousemask( 	BUTTON1_CLICKED |
				BUTTON2_CLICKED |
				BUTTON3_CLICKED |
				#if NCURSES_MOUSE_VERSION > 1
					BUTTON4_TRIPLE_CLICKED |
					BUTTON5_TRIPLE_CLICKED |
				#endif
				BUTTON_SHIFT |
				BUTTON_CTRL, NULL);
	
	//mousemask(ALL_MOUSE_EVENTS, NULL);
	mouseinterval(10);
}

void	MouseDestroy()
{
	// curses 마우스 설정
	mousemask(0, NULL);
}

void	ScreenClear()
{
	clear();
	refresh();
}

};
