/***************************************************************************
                          mfskdemodulator.h  -  description
                             -------------------
    begin                : Mit Jan 29 2003
    copyright            : (C) 2003 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   The PSK part is based on WinPSK 1.0 by Moe Wheatley, AE4JY            *              
 ***************************************************************************/

#ifndef MFSKDEMODULATOR_H
#define MFSKDEMODULATOR_H

#include "fskdemodulator.h"
#include <complex>
#include <vector>
#include "deinterleaver.h"
using namespace std;
//class Deinterleaver;
class Viterbi;
class MFSKVaricode;
/**
  *@author Volker Schroer
  */
static char GraydecodeTable[16][4]={ {'0','0','0','0'}, //  0
                              {'0','0','0','1'}, //  1
			      {'0','0','1','1'}, //  2
			      {'0','0','1','0'}, //  3
			      {'0','1','1','0'}, //  4
			      {'0','1','1','1'}, //  5
			      {'0','1','0','1'}, //  6
			      {'0','1','0','0'}, //  7
			      {'1','1','0','0'}, //  8
			      {'1','1','0','1'}, //  9
			      {'1','1','1','1'}, // 10
			      {'1','1','1','0'}, // 11
			      {'1','0','1','0'}, // 12
			      {'1','0','1','1'}, // 13
			      {'1','0','0','1'}, // 14
			      {'1','0','0','1'}  // 15
};
class MFSKDemodulator : public FSKDemodulator  {
public: 
  MFSKDemodulator();
  ~MFSKDemodulator();
 /** Prozess the input */
 void ProcessInput(double * input,double *);
 int getSquelchValue();
 bool Init(double,int);
 virtual double get2RxFrequency();

private:

MFSKVaricode *Decoder;
//Deinterleaver leave0,leave1,leave2,leave3,leave4,
//leave5,leave6,leave7,leave8,leave9;

Deinterleaver leave[10];
Viterbi * viterbi;
void decodesymbol(double *,unsigned char *);
void recvbit(int);
void synchronize();
void afc();
AfcMode AfcProperties();
unsigned int Bitshiftregister;

public slots: // Public slots
/** Set RxFrequencies for MFSK16 */
 void setRxFrequency(double);


inline unsigned char graydecode(unsigned char data)
{
	return data ^ (data >> 1);
}

};

#endif
