/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

void	l2sr_popup(STOCK *sp, STREAMER sr);
int	l2sr_command(int c, STREAMER sr);

void	l2sr_display(STREAMER sr, int on);

char	*mmid_lookup(char *mmid);

/*
 * T&S Trade record
 */
#define	TS_ATHIGH	3
#define	TS_ABOVE	2
#define	TS_ATASK	1
#define	TS_SPREAD	0
#define	TS_ATBID	-1
#define	TS_BELOW	-2
#define	TS_ATLOW	-3
void	l2sr_trade(STREAMER sr, double price, int size, int time,
	    int row, int tstype);

/*
 * Order book interface from streamer to popup
 *
 * For SEAQ style order book.
 */
typedef struct
{
	#define MMIDLEN	8
	char	mmid[MMIDLEN+1];

	double	bid;
	int	bidsz;
	double	ask;
	int	asksz;
	int	time;			// Time in seconds since midnight
	char	code;
	char	bidtick;
	char	asktick;
} L2BA;

void	l2sr_ba(STREAMER sr, char *sym, L2BA *bap, int numba);
int	l2sr_getlast(STREAMER sr, char *sym, char *mmid, L2BA *bap);

/*
 * Order book interface from streamer to popup
 *
 * For SETS style order book.
 */
typedef struct
{
	#define RECIDLEN	12
	char	recid[RECIDLEN+1];	// Record ID
	char	mmid[MMIDLEN+1];

	double	price;
	int	size;
	int	time;			// Time in seconds since midnight
	int	key2;
	char	isbid;
	char	code;
	char	tick;
} L2SETS;

void	l2sr_sets(STREAMER sr, char *sym, L2SETS *setsp, int numsets);
