/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#include <stdlib.h>
#include <string.h>
#include <ncurses.h>
#include <panel.h>
#include <time.h>
#include <sys/time.h>
#include "error.h"
#include "rc.h"
#include "streamer.h"
#include "linuxtrade.h"
#include "stocklist.h"

static char Fmt[] = "%s\t%d\t%.2f\t%s\n";

void
stocklist_write(int num)
{
	int	i;
	FILE	*fp;
	char	buf[512];
	char	*home = getenv("HOME");

	if (!home)
		error(1, "Can't find $HOME\n");

	sprintf(buf, "%s/." PROGNAMESTR "/%d.list", home, num);
	fp = fopen(buf, "w");
	if (!fp)
		error(1, "Can't write '%s'\n", buf);

	fprintf(fp, "# Stocklist %d\n", num);
	fprintf(fp, "#\n");
	fprintf(fp, "# Name: %s\n", StockListName);
	fprintf(fp, "#\n");
	fprintf(fp, "# A list of symbols, one per line.\n");
	fprintf(fp, "#\n");
	fprintf(fp, "#SYMBOL	[SHARES	TOTCOST COMMENT]\n");
	for (i = 0; i < NumStock; ++i)
	{
		STOCK	*sp = &Stock[i];

		fprintf(fp, Fmt, sp->sym, sp->nshares, sp->cost, sp->comment);
	}

	fclose(fp);
}

char *
stocklist_read(int num)
{
	FILE		*fp;
	char		buf[512];
	char		*home = getenv("HOME");
	static char	list[4096];

	sprintf(buf, "%s/." PROGNAMESTR "/%d.list", home, num);
	fp = fopen(buf, "r");
	if (!fp)
		return "";

	list[0] = 0;
	StockListName[0] = 0;
	while (fgets(buf, sizeof(buf), fp))
	{
		char	*p;

		if (strncmp(buf, "# Name: ", 8) == 0)
		{
			p = strchr(buf, '\n');
			if (p) *p = 0;
			strncpy(StockListName, buf+8, sizeof(StockListName)-1);
			StockListName[sizeof(StockListName)-1] = 0;
		}

		if (buf[0] == '#')
			continue;

		p = strchr(buf, ' ');
		if (p) *p = 0;
		p = strchr(buf, '\t');
		if (p) *p = 0;
		p = strchr(buf, '\n');
		if (p) *p = 0;

		if (list[0])
			strcat(list, " ");
		strcat(list, buf);
	}

	fclose(fp);

	return list;
}

void
stocklist_add(int num, STOCK *sp)
{
	FILE	*fp;
	char	buf[512];
	char	*home = getenv("HOME");

	sprintf(buf, "%s/." PROGNAMESTR "/%d.list", home, num);
	fp = fopen(buf, "a");
	if (!fp)
		return;

	fprintf(fp, Fmt, sp->sym, 0, 0.0, sp->comment);

	fclose(fp);
}

void
stocklist_holdings(int num)
{
	FILE		*fp;
	char		buf[512];
	char		com[512];
	char		*home = getenv("HOME");

	if (!num)
		return;

	sprintf(buf, "%s/." PROGNAMESTR "/%d.list", home, num);
	fp = fopen(buf, "r");
	if (!fp)
		return;

	while (fgets(buf, sizeof(buf), fp))
	{
		int	rc;
		char	sym[SYMLEN+1];
		int	nshares;
		double	cost;
		STOCK	*sp;

		if (buf[0] == '#')
			continue;

		rc = sscanf(buf, "%[^	]\t%d\t%lf\t%[^\t\n]",
				sym, &nshares, &cost, com);

		if (rc < 3)
			continue;

		sp = find_stock(sym);
		if (!sp)
			continue;

		sp->nshares = nshares;
		sp->cost = cost;
		if (rc >= 4)
		{
			strncpy(sp->comment, com, COMLEN);
			sp->comment[COMLEN] = 0;
		}
		else
			sp->comment[0] = 0;
	}

	fclose(fp);

	return;
}

int
stocklist_find(char *name)
{
	FILE	*fp;
	int	i;
	char	buf[512];
	char	*home = getenv("HOME");

	for (i = 1; i <= 99; ++i)
	{
	    sprintf(buf, "%s/." PROGNAMESTR "/%d.list", home, i);
	    fp = fopen(buf, "r");
	    if (!fp)
		continue;

	    while (fgets(buf, sizeof(buf), fp))
	    {
		char	*p;

		if (buf[0] != '#')
		    break;
		if (strncmp(buf, "# Name: ", 8) != 0)
		    continue;

		p = strchr(buf, '\n'); if (p) *p = 0;
		if (strstr(buf, name))
		{
		    fclose(fp);
		    return i;
		}
	    }
	    fclose(fp);
	}
	return (0);
}
