/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

typedef struct streamerpub	*STREAMER;
typedef struct streamerpriv	*STREAMERPRIV;

#define	SR_ERR	-1
#define	SR_AUTH	-100

typedef struct streamerpub
{
	int 	(*open)(
			STREAMER sr, RCFILE *rcp,
			FILE *readfile
			);
	int	(*select)(
			STREAMER sr,
			int n, fd_set *readfds, fd_set *writefds,
			fd_set *exceptfds, struct timeval *timeout
			);
	void	(*close)(STREAMER sr);

	void	(*record)(STREAMER sr, FILE *fp);

	void	(*timetick)(STREAMER sr, time_t now);
			#define TICKHZ	1

	// Quotes...
	void	(*send_quickquote)(STREAMER sr, char *sym);

	void	(*send_livequote)(STREAMER sr, char *sym);
	void	(*send_livequote_end)(STREAMER sr);

	void	(*send_symbols)(STREAMER sr, char *symbols, int add);
	void	(*send_symbols_end)(STREAMER sr, int add, int all);

	// Misc...
	void	(*send_disconnect)(STREAMER sr);
	void	(*send_top10)(STREAMER sr, char market, int type, int add);
	void	(*send_movers)(STREAMER sr, int on);
	void	(*send_info)(STREAMER sr, char *sym, int type);
	void	(*send_optchain)(STREAMER sr, char *sym);
	int	(*send_chart)(STREAMER sr, char *sym,
				int freq, int periods, int days);

	// News...
	void	(*send_headlines)(STREAMER sr, char *sym, int numlines);
	void	(*send_article)(STREAMER sr, char *artkey);
		// should add one if the streamer can/can't stream news. So
		// far, send_headlines implies this.

	// L2...
	int	(*send_l2)(STREAMER sr, char *sym, int add);

	// Incoming data...
	int	(*process)(STREAMER sr, int fdindex);

	//
	// Public data
	//
	int	refresh;	// Number of seconds between symbol refreshes
	int	nfd;
	int	fd[8];
	char	id[256];
	FILE	*readfile;
	FILE	*writefile;
	int	usenews;	// Copied from streamer prefs

	// Stats...
	int	cnt_opens;	// Number of streamer opens
	int	cnt_realopens;	// Number of streamer realopens
	int	cnt_rx;		// Count of bytes received
	time_t	time_start;	// Time when streamer was first selected
	time_t	time_open;	// Time when streamer was last opened
	time_t	time_realopen;	// Time when streamer was last realopen'ed

	STREAMERPRIV	priv;
} STREAMERPUB;

STREAMER	null_new(void);
STREAMER	advfn_new(void);
STREAMER	ameritrade_new(void);
STREAMER	freetrade_new(void);
STREAMER	datek_new(void);
STREAMER	esignal_new(void);
STREAMER	moneyam_new(void);
STREAMER	moneynet_new(void);
STREAMER	quotemedia_new(void);
STREAMER	schwab_new(void);
STREAMER	scottrader_new(void);
STREAMER	sonictrading_new(void);
STREAMER	swissquote_new(void);
STREAMER	yahoo_new(void);

FILE	*StreamerLog;

/*
 * Return entire list of known canonical symbols (kept in scottrader.c)
 */
int	index_list(char *buf, int size);

/*
 * Convert an extended canonical symbol to Yahoo format
 */
void	yahoo_canon2sym(char *out, char *in);
void	yahoo_sym2canon(char *out, char *in);

/*
 * Common routines used by many streamers
 */
void	streamer_free(STREAMER sr);
ssize_t	streamer_write_ascii(int fd, void *buf, size_t count);
ssize_t	streamer_write_binary(int fd, void *buf, size_t count);
int	streamer_printf(int fd, char *fmt, ...);
int	streamer_printf2(int fd, char *fmt, ...);
ssize_t streamer_read(STREAMER sr, int fdindex, void *buf, size_t count);
ssize_t streamer_mustread(STREAMER sr, int fdindex, void *buf, size_t count);

/*
 * Line buffer
 */
typedef struct
{
	int	fd;		// fd this buffer is associated with
	char	*buf;		// the buffer itself
	int	buflen;		// the buffer length
	char	*bufp;		// the current read position in the buffer
	char	*bufe;		// the end of the valid portion of the buffer

	int	cnt_rx;		// Statistic: total bytes read
	char	*debug_tag;	// Tag to prefix debug lines with
} LINEBUF;

void linebuf_init(LINEBUF *lb);
int linebuf_open(LINEBUF *lb, int fd, int buflen);
void linebuf_close(LINEBUF *lb);
int linebuf_avail(LINEBUF *lb);
int linebuf_gets(LINEBUF *lb, char *buf, int buflen);
void linebuf_tag(LINEBUF *lb, char *tag);
