# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###




import gtk
import gobject

import stock
import config

from helper import helper
from widget.smart_playlist import SmartPlaylistWindow

class Source(gobject.GObject):
    
    load_priority = 100
    display_index = 10000
        
    __gsignals__ = {
        "source-changed" : (gobject.SIGNAL_RUN_FIRST,gobject.TYPE_NONE,())
    }

    def __init__(self,player):
        gobject.GObject.__init__(self)
        self.items = []
        self.player = player
        
        
    def get_items(self):
        return self.items
    
    def load(self,player):
        pass
    
    def save(self):
        pass

    def run(self):
        pass
    
    def get_default_menu(self):
        return []

class SourceItem:
    has_top_separateur = False
    has_bottom_separateur = False
    is_droppage = False
    source_id = None
    editable = False
    selected = False
    default_selected = False
    def __init__(self,player,stock=stock.SRC_BIBLIO,label=_("Unknown source"),widget=None,config_code=None):
        self.stock = stock
        self.label = label
        self.widget = widget
        self.config_code = config_code
        self.source_id = None
    
    def is_hidden(self):
        if self.config_code:
            return not config.get("source", self.config_code)=="1"
        else:
            return False
    
    def on_edition(self,new_text):
        return False
    
    def on_activated(self):
        pass
    
    def on_drag_data_get(self,context, selection, info):
        return False

    def on_drag_song_received(self,songs):
        return False
    
    def on_key_press(self,event):
        return False
    
    def get_menu(self):
        pass

      
class PlaylistSourceItem(SourceItem):
    is_droppage = True
    def __init__(self,player,pl,stock,label,widget,config_code):
        SourceItem.__init__(self,player,stock,label,widget,config_code)
        self.pl = pl
        self.editable = True


    def on_drag_data_get(self,context, selection, info):
        list_uri = list([ song.get("uri") for song in self.pl.get_songs()])
        selection.set("text/listen-songs", 8, "\n".join(list_uri))
        selection.set_uris(list_uri)
        return True
        
    def on_drag_song_received(self,songs):
        self.pl.append(songs)
        return False
    
    def on_edition(self,new_text):
        self.pl.name = new_text
        self.label = new_text
        return True
    
    def on_key_press(self,event):
        if event.keyval == gtk.gdk.keyval_from_name("Delete"):
            self.remove_playlist(None)
            return True
        elif event.keyval == gtk.gdk.keyval_from_name("<Control>r"):
            self.edit_playlist(None)
            return True
        else:
            return False
    
    def on_activated(self):
        self.play_playlist()
        
    def play_playlist(self,w=None):
        songs = self.pl.get_songs()
        if len(songs)>0:
            helper.cur_playlist_play(songs)
               
    def enqueue_playlist(self,w):
        songs = self.pl.get_songs()
        if len(songs)>0:
            helper.cur_playlist_enqueue(songs)
            
    def remove_playlist(self,w):
        self.pl.library.delete_playlist(self.pl)
        
    def edit_playlist(self,w):
        helper.edit_source()
        
    def edit_smart_playlist(self,w):
        win = SmartPlaylistWindow(self.pl)
        win.run()
        
    def get_menu(self):
        menu = gtk.Menu()
        item = gtk.ImageMenuItem(stock.PLAY)
        item.connect("activate",self.play_playlist)
        menu.append(item)
        item = gtk.ImageMenuItem(stock.ENQUEUE)
        item.connect("activate",self.enqueue_playlist)
        menu.append(item)
        
        if self.pl.is_smart():
            menu.append(gtk.SeparatorMenuItem())    
            item = gtk.ImageMenuItem(stock.EDIT)
            item.connect("activate",self.edit_smart_playlist)
            menu.append(item)
        
        if self.editable:
            menu.append(gtk.SeparatorMenuItem())    
            item = gtk.ImageMenuItem(stock.RENAME)
            item.connect("activate",self.edit_playlist)
            menu.append(item)
            item = gtk.ImageMenuItem(stock.DELETE)
            item.connect("activate",self.remove_playlist)
            menu.append(item)
            
        menu.show_all()
        return menu
    
    
    
    
    
    
    
    
    
    
    
    
