# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###




import gtk, gobject
import os
import gnomevfs

import stock, utils, const, config


from  _source import Source,SourceItem,PlaylistSourceItem
from library import library_wrapper
from library.ipod import IpodPlaylist,IpodLibrary
from widget.dialog import WindowBase
from widget.browser import Browser
from widget.song_view import SortableSongView,SongView,PlaylistSongView
from widget.song_menu import SongMenu
from widget.misc import ScrolledWindow
from helper import helper
from hal import hal


try: import gpod
except : pass
    
class IpodSource(Source):
    display_index = 60    
    def __init__(self,player):
        Source.__init__(self,player)

        self.player = player
        self.ipod_librarys = []
        self.ipod_items = {}
        
        helper.connect("playlist-added",self.add_playlist)
        helper.connect("playlist-removed",self.remove_playlist)

    def add_playlist(self,helper,pl):
        for l in self.ipod_librarys:
            if pl.codeName != l.codeName or pl.library.udi != l.udi: return
            pl_view = IpodPlaylistSongView(pl)
            pl_item = IpodPlaylistSourceItem(self.player,pl,stock.SRC_PLAYLIST_IPOD,pl.name,ScrolledWindow(pl_view),"ipod")
            self.ipod_items[l.udi].append(pl_item)
            pl_view.get_model().fill(pl.get_songs())
            self.build_source_items()

        
    def remove_playlist(self,helper,pl):
        for l in self.ipod_librarys:        
            if pl.codeName != l.codeName  or pl.library.udi != l.udi : return    
            self.ipod_items[l.udi] = [item for item in self.ipod_items[l.udi] if not isinstance(item,IpodPlaylistSourceItem) or item.pl!=pl]
            self.build_source_items() 
                    
    def get_default_menu(self):
        def new_playlist(w,l):
            l.add_playlist(IpodPlaylist(l,_("New Playlist")))
            
        def new_smart_playlist(w,l):
            pass    
        
        factory = gtk.IconFactory()
        items = []
        for l in self.ipod_librarys:
            pl_stock = "ipod-pl-"+l.get_pl_master().name
            pl_smart_stock = "ipod-smart-pl-"+l.get_pl_master().name
            icons = gtk.IconFactory()
            icons.add(pl_stock, gtk.icon_factory_lookup_default(stock.SRC_PLAYLIST_IPOD))
            icons.add(pl_smart_stock, gtk.icon_factory_lookup_default(stock.SRC_PLAYLIST_SMART))
            icons.add_default()
            
            gtk.stock_add([
            (pl_stock, _("_New iPod (%s) Playlist")%l.get_pl_master().name, 0, 0, ""),
            (pl_smart_stock,  _("_New iPod (%s) _Automatique Playlist...")%l.get_pl_master().name, 0, 0, "")
            ])
            item1 = gtk.ImageMenuItem(pl_stock)
            item1.connect("activate",new_playlist,l)
            item2 = gtk.ImageMenuItem(pl_smart_stock)
            item2.connect("activate",new_smart_playlist,l)
            items.append(item1)
            #items.append(item2)
        return items
            
        
    def check(self,hal,volume,udi):
        prop = hal.get_property(udi)    
        if prop.has_key("info.parent") and prop.has_key("info.parent")!="":
            prop2 = hal.get_property(prop["info.parent"])
            if prop2.has_key("storage.model") and prop2["storage.model"]=="iPod":
               return True
        return False  
    
    def mount(self,hal,volume,udi):
        m = hal.get_mount_point(udi)
        print "ipod mounted at ",m

        ipod_library = IpodLibrary(m,udi)
        if ipod_library.load():
            ipod_library.load_library()
            paned_browser = IpodBrowser(ipod_library.get_pl_master())
            paned_browser_item = IpodLibrarySourceItem(self.player,ipod_library.get_pl_master(),stock.SRC_IPOD,utils.xmlescape(ipod_library.get_pl_master().name),paned_browser,"ipod")
            self.ipod_items.setdefault(udi,[]).append(paned_browser_item)
            
            pl = ipod_library.get_pl_podcast()
            if pl:
                kargs = {
                        "artist":(0,gobject.TYPE_STRING),
                        "title":(1,gobject.TYPE_STRING),
                        "feed":(2,gobject.TYPE_STRING),
                        "#duration":(3,gobject.TYPE_STRING),
                        "#playcount":(4,gobject.TYPE_STRING),
                        "#lastplayed":(5,gobject.TYPE_STRING)
                      }    
                pl_view = IpodPlaylistSongView(pl,**kargs)
                pl_view.get_column(0).set_title(_("Date"))
                pl_item = IpodPodcastSourceItem(self.player,pl,stock.SRC_PODCAST_IPOD,pl.name,ScrolledWindow(pl_view),"ipod")
                self.ipod_items[udi].append(pl_item)
                pl_view.get_model().fill(pl.get_songs())
                
            for pl in ipod_library.get_pl_normal():
                pl_view = IpodPlaylistSongView(pl)
                pl_item = IpodPlaylistSourceItem(self.player,pl,stock.SRC_PLAYLIST_IPOD,pl.name,ScrolledWindow(pl_view),"ipod")
                self.ipod_items[udi].append(pl_item)
                pl_view.get_model().fill(pl.get_songs())
                
            paned_browser.populate()
            self.build_source_items()
            
        self.ipod_librarys.append(ipod_library)
           
    def pre_umount (self,hal,volume,udi):
        for l in self.ipod_librarys:
            if l.udi == udi:
                l.free()    
        return
        for l in self.ipod_librarys:
            if l.udi == udi:
                l.save()
        
    def umount (self,hal,volume,udi):
        if self.ipod_items.has_key(udi):
            if isinstance(self.ipod_items[udi],IpodBrowser):
                self.ipod_items[udi].save_config()
            del self.ipod_items[udi]
            self.build_source_items()
            
    def save(self):
        for udi,item in self.ipod_items.iteritems():
            if isinstance(item,IpodBrowser):
                item.save_config()
            
    def load(self,player):
        try: import gpod
        except : pass
        else: 
            gobject.idle_add(hal.register_volume,self.check,self.mount,self.pre_umount,self.umount)
        
    def build_source_items(self):
        self.items = []
        for udi,items in self.ipod_items.iteritems():
            self.items.extend(items)
        helper.update_source()
        
            
        
class IpodBrowser(Browser):
    def __init__(self,pl):
        super(IpodBrowser,self).__init__(pl,pl.library.codeName,True)
        self.set_song_treeview(IpodSongView(pl,pl.library.codeName))
        self.treeviews["songs"].set_sort_by(None,"album", gtk.SORT_ASCENDING, False)

        menu = SongMenu(pl,True,True,True,False,True,False,False)
        menu.show_all()
        self.set_menu(menu)
        
    def on_key_press(self,event):
            return False
        

class IpodPlaylistSourceItem(PlaylistSourceItem):
    def __init__(self,player,pl,stock,label,widget,config_code):
        PlaylistSourceItem.__init__(self,player,pl,stock,label,widget,config_code)
        if pl.is_podcast():
            self.editable = False
        
    def on_edition(self,new_text):
        if self.pl.ipod_pl.name != str(new_text):
            self.pl.ipod_pl.name = str(new_text)
            self.pl.library.sync_ipod()
        return PlaylistSourceItem.on_edition(self,new_text)
    
        
class IpodPodcastSourceItem(IpodPlaylistSourceItem):
    def on_key_press(self,event):
        return False

        
class IpodLibrarySourceItem(IpodPlaylistSourceItem):
    has_top_separateur = True
    is_droppage = True
    
    def on_key_press(self,event):
        return False
    
    def on_drag_song_received(self,songs):
        self.pl.append(songs)
        return False 
    
    def get_menu(self):
        menu = gtk.Menu()
        def new_playlist(w):
            self.pl.library.add_playlist(IpodPlaylist(self.pl.library,_("New Playlist")))
            
        def new_smart_playlist(w):
            pass
        
        def save_ipod_db(w):
            self.pl.library.save()   
            
        def on_add_cover(w):
            from widget.progress import action_progress
            def on_add_cover_bg():
                songs = self.pl.library.songs
                i = 0
                total = len(songs)
                for uri,song in songs.iteritems():
                    art = song.get_cover(False)
                    if art!=const.DEFAULT_COVER:
                        track = self.pl.library.ipod_track[uri]
                        gpod.itdb_track_set_thumbnails(track,str(art))
                    i += 1
                    yield _("Adding cover to file ")+" %d/%d..."%(i,total),float(i)/float(total),False    
                self.pl.library.sync_ipod()
                        
            def on_add_cover_bg_cb():
                self.pl.library.sync_ipod()
                
            action_progress.add_queue("Adding cover...",on_add_cover_bg,cb=on_add_cover_bg_cb)
            
            
        l = self.pl.library
        pl_stock = "ipod-pl-"+l.get_pl_master().name
        pl_smart_stock = "ipod-smart-pl-"+l.get_pl_master().name
        icons = gtk.IconFactory()
        icons.add(pl_stock, gtk.icon_factory_lookup_default(stock.SRC_PLAYLIST_IPOD))
        icons.add(pl_smart_stock, gtk.icon_factory_lookup_default(stock.SRC_PLAYLIST_SMART))
        icons.add_default()
        
        gtk.stock_add([
        (pl_stock, _("_New iPod (%s) Playlist")%l.get_pl_master().name, 0, 0, ""),
        (pl_smart_stock,  _("_New iPod (%s) _Automatique Playlist...")%l.get_pl_master().name, 0, 0, "")
        ])
        item = gtk.ImageMenuItem(pl_stock)
        item.connect("activate",new_playlist)
        menu.append(item)
        item = gtk.ImageMenuItem(pl_smart_stock)
        item.connect("activate",new_smart_playlist)
        #menu.append(item)
        item = gtk.MenuItem(_("Add missing cover"))
        item.connect("activate",on_add_cover)
        menu.append(item)
        menu.append(gtk.SeparatorMenuItem())
        item = gtk.ImageMenuItem(stock.RENAME)
        item.connect("activate",self.edit_playlist)
        menu.append(item)
        """item = gtk.MenuItem(_("Force save iPod database"))
        item.connect("activate",save_ipod_db)
        menu.append(item)"""
        item = gtk.ImageMenuItem(gtk.STOCK_PROPERTIES)
        item.connect("activate",self.show_property)
        menu.append(item)
        menu.show_all()
        return menu
    
    def show_property(self,w):
        dialog = WindowBase(_("iPod Property"),const.PIXMAP_DIR+"/ipod_big.png",(gtk.STOCK_CLOSE, gtk.RESPONSE_CLOSE,))

        prop = hal.get_property(self.pl.library.udi)   
        dialog.label_heading.set_markup("<span size=\"large\"><b>"+self.pl.library.model+" ("+utils.str_size(prop["volume.size"] ,0,1000)+")</b></span>\n"+_("Firmware")+": "+self.pl.library.firmware)
        hbox = gtk.HBox(0,6)
        l = gtk.Label(_("Name")+" : "+utils.xmlescape(self.pl.name))
        #l.set_alignement(0,0.5)
        hbox.pack_start(l)

        used = utils.du(self.pl.library.mount_point)
        
        free = prop["volume.size"] - used

        frac = float(used) / float(prop["volume.size"])
        progress = gtk.ProgressBar()
        progress.set_fraction(frac)
        progress.set_text("%s Free space"%utils.str_size(used,1))
        dialog.add_widget(hbox)
        dialog.add_widget(progress)
        dialog.show_all()
        dialog.run()
        dialog.destroy()
        
class IpodPlaylistSongView(PlaylistSongView):
    def __init__(self,pl,**kargs):
        super(IpodPlaylistSongView,self).__init__(pl,**kargs)
        menu = SongMenu(pl,True,True,False,False,True,False)
        if not pl.is_smart(): menu.insert_item(self.delete,stock.DELETE,2)
        menu.show_all()
        self.set_menu(menu)
        
class IpodSongView(SortableSongView):
    def __init__(self,pl,conf_prefix):
        super(IpodSongView,self).__init__(pl,conf_prefix)
        
        menu = SongMenu(pl,True,True,True,False,True,False,False)
        menu.show_all()
        self.set_menu(menu)
        
            
