# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###



import gtk, gobject
import os, gnomevfs
from time import time

import stock, utils, const, config

from  _source import Source,SourceItem,PlaylistSourceItem
from widget.browser import Browser

from widget.song_view import SortableSongView,SongView,PlaylistSongView
from widget.song_menu import SongMenu
from widget.misc import ScrolledWindow
from widget.dialog import WindowNewPodcast,WindowNewRadio,WindowExportPlaylist
from widget.smart_playlist import SmartPlaylistWindow
from widget.radio_browser import RadioWidget
from helper import helper

from library import Library,Playlist,library_wrapper,PL_SMART
from library.local import LocalLibrary,LocalPlaylist
from widget.progress import action_progress


class LocalSource(Source):
    load_priority = 0
    display_index = 50
    def __init__(self,player):
        Source.__init__(self,player)

        self.local_library = LocalLibrary()
        
        helper.connect("playlist-added",self.add_playlist)
        helper.connect("playlist-removed",self.remove_playlist)

    def add_playlist(self,helper,pl):
        if pl.codeName!=self.local_library.codeName: return
        pl_view = PlaylistSongView(pl)
        if pl.is_smart():
            icon = stock.SRC_PLAYLIST_SMART
        else:
            icon = stock.SRC_PLAYLIST
        pl_item = LocalPlaylistSourceItem(self.player,pl,icon,pl.name,ScrolledWindow(pl_view),"locallibrary")
        self.items.append(pl_item)
        pl_view.get_model().fill(pl.get_songs())
        helper.update_source()
        
    def remove_playlist(self,helper,pl):
        if pl.codeName!=self.local_library.codeName: return    
        self.items = [item for item in self.items if not isinstance(item,LocalPlaylistSourceItem) or item.pl!=pl]
        helper.update_source()    
            
        
    def save(self):
        if self.paned_browser:
            self.paned_browser.save_config()
        
    def load(self,player):
        self.paned_browser = None
        fake_paned_browser = gtk.Label("<i><span size=\"x-large\">"+_("Loading...")+"</span></i>")
        fake_paned_browser.set_use_markup(True)
        paned_browser_item = FakeLocalLibrarySourceItem(player,stock.SRC_BIBLIO,_("Library\n<small><i>Loading...</i></small>"),fake_paned_browser,"locallibrary")
        self.items.append(paned_browser_item)
        import threading
        t = threading.Thread(target=self.thread_load,args=(player,))
        t.setDaemon(True)
        t.start()

    def thread_load(self,player):
        self.local_library.load()
        gobject.idle_add(self.post_load,player)

    def post_load(self,player):
        self.paned_browser = LocalBrowser(self.local_library.get_pl_master())
        paned_browser_item = LocalLibrarySourceItem(player,stock.SRC_BIBLIO,_("Library"),self.paned_browser,"locallibrary")
        paned_browser_item.selected =  self.items[0].selected

        #Free ressource of fake treeviews
        self.items[0].widget.get_parent().remove(self.items[0].widget)
        self.items[0].widget.destroy()
        del self.items[0]

        self.items = [paned_browser_item]

        podcast_browser = PodcastBrowser(self.local_library.get_pl_podcast())
        podcast_item = PodcastSourceItem(player,stock.SRC_PODCAST,_("Podcast"),podcast_browser,"podcast")
        self.items.append(podcast_item)
        
        radio_browser = RadioWidget(self.local_library.get_pl_iradio())
        radio_item = RadioSourceItem(player,stock.SRC_IRADIO,_("Webradio"),radio_browser,"iradio")
        self.items.append(radio_item)
        
            
        
        for pl in self.local_library.playlists:
            if pl.is_smart() or pl.is_normal():
                pl_view = PlaylistSongView(pl)
                if pl.is_smart():
                    icon = stock.SRC_PLAYLIST_SMART
                else:
                    icon = stock.SRC_PLAYLIST
                pl_item = LocalPlaylistSourceItem(player,pl,icon,pl.name,ScrolledWindow(pl_view),"locallibrary")
                self.items.append(pl_item)
                pl_view.get_model().fill(pl.get_songs())
                 
        podcast_browser.populate()
        radio_browser.populate()
        self.paned_browser.populate()
        
        self.timeout_download_podcast(config.get("podcast","startup")=="true")
        helper.update_source()
        
    def timeout_download_podcast(self,start_now=True):
        if start_now:
            self.local_library.refresh_podcasts(self.local_library.get_pl_podcast().get_songs())
        if int(float(config.get("podcast","time_refresh")))>2:
            refresh_time = int(float(config.get("podcast","time_refresh")))*60*100
            gobject.timeout_add(refresh_time,self.timeout_download_podcast)
            
    def get_default_menu(self):
        if not self.paned_browser: return []

        def new_playlist(w):
            pl = LocalPlaylist(self.local_library,_("New Playlist"))
            self.local_library.add_playlist(pl)
            gobject.idle_add(helper.edit_playlist,pl)
            
        def new_smart_playlist(w):
            pl = LocalPlaylist(self.local_library,_("New Automatic Playlist"),PL_SMART)   
            win = SmartPlaylistWindow(pl,True)
            pl = win.run()
            if pl:
                self.local_library.add_playlist(pl)
                gobject.idle_add(helper.edit_playlist,pl)

        def new_podcast(w):
            w = WindowNewPodcast()
            
        def new_radio(w):
            w = WindowNewRadio()
            
        item1 = gtk.ImageMenuItem(stock.SRC_PLAYLIST)
        item1.connect("activate",new_playlist)
        item2 = gtk.ImageMenuItem(stock.SRC_PLAYLIST_SMART)
        item2.connect("activate",new_smart_playlist)
        item3 = gtk.ImageMenuItem(stock.NEW_PODCAST)
        item3.connect("activate",new_podcast)
        item4 = gtk.ImageMenuItem(stock.NEW_RADIO)
        item4.connect("activate",new_radio)
        return [item1,item2,item3,item4]


class LocalPlaylistSourceItem(PlaylistSourceItem):
    def get_menu(self):
        menu = PlaylistSourceItem.get_menu(self)    
        if utils.iscommand("serpentine"):    
            menu.append(gtk.SeparatorMenuItem())
        item = gtk.ImageMenuItem(stock.EXPORT)
        item.connect("activate",self.export)
        menu.append(item)
        if utils.iscommand("serpentine"):
            item = gtk.ImageMenuItem(stock.BURN)
            item.connect("activate",self.burn)
            menu.append(item)
        menu.show_all()
        return menu
    
    def export(self,w):
        WindowExportPlaylist(self.pl.get_songs()).run()
        
    def burn(self,w):
        utils.burn(self.pl.get_songs())

class FakeLocalLibrarySourceItem(SourceItem):
    default_selected = True
    has_top_separateur = True

class LocalLibrarySourceItem(SourceItem):
    default_selected = True
    has_top_separateur = True
    def on_import_folder(self,w):
        l = library_wrapper.get_library("local")
        l.import_folder()
        
    def on_import_file(self,w):
        l = library_wrapper.get_library("local")
        l.import_file()
        
    def on_reload_db(self,w):
        l = library_wrapper.get_library("local")
        l.reload_db()
        
    def get_menu(self): 
        menu = gtk.Menu()     
        def new_playlist(w):
            l = library_wrapper.get_library("local")
            pl = LocalPlaylist(l,_("New Playlist"))
            l.add_playlist(pl)
            gobject.idle_add(helper.edit_playlist,pl)
            
        def new_smart_playlist(w):
            l = library_wrapper.get_library("local")
            pl = LocalPlaylist(l,_("New Automatic Playlist"),PL_SMART)   
            win = SmartPlaylistWindow(pl,True)
            pl = win.run()
            if pl:
                l.add_playlist(pl)
                gobject.idle_add(helper.edit_playlist,pl)
            
        def on_download_cover(w):
            library_wrapper.get_library("local").download_all_cover()

                
            
        item = gtk.ImageMenuItem(stock.IMPORT_FILE)
        item.connect("activate",self.on_import_file)
        menu.append(item)
        item = gtk.ImageMenuItem(stock.IMPORT_FOLDER)
        item.connect("activate",self.on_import_folder)
        menu.append(item)
        menu.append(gtk.SeparatorMenuItem())
        
        item = gtk.ImageMenuItem(stock.RELOAD_LIBRARY)
        item.connect("activate",self.on_reload_db)
        menu.append(item)
        
        item = gtk.MenuItem(_("Download missing cover"))
        item.connect("activate",on_download_cover)
        menu.append(item)
        menu.append(gtk.SeparatorMenuItem())
        item = gtk.ImageMenuItem(stock.SRC_PLAYLIST)
        item.connect("activate",new_playlist)
        menu.append(item)
        item = gtk.ImageMenuItem(stock.SRC_PLAYLIST_SMART)
        item.connect("activate",new_smart_playlist)
        menu.append(item)
        menu.show_all()
        return menu

class PodcastSourceItem(SourceItem):
    def get_menu(self): 
        menu = gtk.Menu()
        def new_podcast(w):
            w = WindowNewPodcast()
           
        item = gtk.ImageMenuItem(stock.NEW_PODCAST)
        item.connect("activate",new_podcast)
        menu.append(item)
        menu.show_all()
        return menu 
      
class RadioSourceItem(SourceItem):
    def get_menu(self): 
        menu = gtk.Menu()
        def new_radio(w):
            w = WindowNewRadio()
           
        item = gtk.ImageMenuItem(stock.NEW_RADIO)
        item.connect("activate",new_radio)
        menu.append(item)
        menu.show_all()
        return menu

class LocalBrowser(Browser):
    def __init__(self,pl):
        super(LocalBrowser,self).__init__(pl,pl.library.codeName,True)
        self.set_song_treeview(LocalSongView(pl,pl.library.codeName))

        self.set_menu(SongMenu(pl))
        
class PodcastBrowser(Browser):
    def __init__(self,pl):
        super(PodcastBrowser,self).__init__(pl,"podcast_"+pl.library.codeName,True,True)
        self.set_song_treeview(PodcastSongView(pl,"podcast_"+pl.library.codeName))
        
        self.label["album"] = _("feed")
        self.labels["album"] = _("feeds")
        
        self.treeviews["album"].get_column(1).set_property("title",_("Feeds"))
        
        self.menu = SongMenu(pl,True,True,True,False,False,False,False)
        self.menu.insert_item(self.new_podcast,stock.NEW_PODCAST)
        self.menu.insert_item(self.refresh_podcasts,gtk.STOCK_REFRESH)
        #self.menu.insert_item_text(self.refresh_podcasts,_("Refresh"))
        self.menu.insert_item_text(self.download_podcasts,_("Download"))
        self.menu.show_all()
        self.empty_menu = SongMenu(pl,False,False,False,False,False,False,False)
        self.empty_menu.insert_item(self.new_podcast,stock.NEW_PODCAST)
        self.empty_menu.show_all()
        self.set_menu(self.menu,self.empty_menu)

    def new_podcast(self,w):
        WindowNewPodcast()
        
    def get_list_type(self):
        return ["album"]
    
    def refresh_podcasts(self,w):
        self.pl.library.refresh_podcasts(self.menu.songs)  
        
    def download_podcasts(self,w):
        self.pl.library.download_podcasts(self.menu.songs)
        
class PodcastSongView(SortableSongView):
    def __init__(self,pl,conf_prefix):
        kargs = {
                        "#date":(0,gobject.TYPE_STRING),
                        "title":(1,gobject.TYPE_STRING),
                        "feed":(2,gobject.TYPE_STRING),
                        "#duration":(3,gobject.TYPE_STRING),
                        "#playcount":(4,gobject.TYPE_STRING),
                        "#lastplayed":(5,gobject.TYPE_STRING)
                      }    
        super(PodcastSongView,self).__init__(pl,conf_prefix,**kargs)
        
        self.menu = SongMenu(pl,True,True,True,False,False,False,False)
        self.menu.insert_item_text(self.download_podcasts,_("Download"))
        self.menu.show_all()
        self.set_menu(self.menu)
        
    def download_podcasts(self,w):
        self.pl.library.download_podcasts(self.menu.songs)

        
class LocalSongView(SortableSongView):
    def __init__(self,pl,conf_prefix):
        super(LocalSongView,self).__init__(pl,conf_prefix)

        self.set_menu(SongMenu(pl))
        

