/*
 * dslk.h -- Digital Unix  header file for lslk
 *
 * V. Abell
 * Purdue University Computing Center
 *
 * Chris Eleveld <chris@sector7.com>
 */


/* $Id: dlslk.h,v 1.8 2000/08/18 18:29:00 abe Exp $ */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */
 
/*
 * to avoid symbol conflicts we jump through some really ugly hoops
 */

#if	!defined(DLSLK_H_DIGUNIX)
#define	DLSLK_H_DIGUNIX	1

#include <setjmp.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <nlist.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <machine/hal_sysinfo.h>

# if	DUV<30000 || DUV>=50000
#include <sys/mount.h>
# endif	/* DUV<30000 || DUV>=50000 */

# if	!defined(SIGALRM)
#define SIGALRM	14	/* alarm clock timeout */
# endif	/* !defined(SIGALRM) */

# if	!defined(SIG_DFL)
#define SIG_DFL	(void (*)())0
# endif	/* !defined(SIG_DFL) */

# if	!defined(SIGINT)
#define SIGINT	2	/* interrupt, generated from terminal special char */
# endif	/* !defined(SIGINT) */

# if	!defined(SIGKILL)
#define SIGKILL	9	/* kill (cannot be caught or ignored) */
# endif	/* !defined(SIGKILL) */


# if	DUV<=20000
#define bool_t	int
# endif	/* DUV<=20000 */

# if DUV<50000
#include <sys/time.h>
# endif	/* DUV<50000 */

# if	DUV>=50100
#include <sys/systm.h>
#define	_SYS_USER_H_
#include <machine/pcb.h>
#undef	_SYS_USER_H_
# endif	/* DUV>=50100 */

#define _KERNEL		1
#define KERNEL		1

#include <fcntl.h>
#include <sys/types.h>

# if	DUV<20000
typedef struct  sigaltstack {
	caddr_t ss_sp;                  /* signal stack pointer */
	int     ss_flags;               /* current status */
	size_t  ss_size;                /* size of stack - 0 if unknown */
} stack_t;
# endif	/* DUV<20000 */

# if	DUV<20000
#define sig_t	void *
#define NSIG	32
typedef unsigned long   sigset_t;

struct sigaction {
    void    (*sa_handler) __((int)); /* signal handler, or action value */
    sigset_t sa_mask;               /* signals to block while in handler */
    int     sa_flags;               /* signal action flags */
};
# endif	/* DUV<20000 */

#include <kern/lock.h>
#define timer_t BBBBBBBBBBBBBB
#define pt_entry_t AAAAAAAAAAAAAA
#define exit kern_exit_AAAAAAAAAAAAAAaa

# if	DUV>=50000
#undef	calloc
#define	calloc	__calloc
# endif	/* DUV>=50000 */

#define _KERNEL		1
#define KERNEL		1
#include <kern/task.h>
#include <sys/proc.h>
#include <sys/user.h>
#include <sys/exit_actn.h>
#include <sys/vnode.h>
#include <sys/flock.h>
#undef _KERNEL
#undef KERNEL
#undef exit

# if	DUV>=50000
#undef	__calloc
#define	__calloc	calloc
# endif	/* DUV>=50000 */

#include <ufs/inode.h>
#include <ufs/mfsnode.h>
#undef i_mode
#undef i_nlink
#undef i_rdev
#undef i_uid
#undef i_gid
#undef i_size
#undef i_gen
#undef i_forw
#undef i_back
#undef i_number
#undef i_dev

# if	DUV<=20000
#undef PIPSIZ
# endif	/* DUV<=20000 */

#include <s5fs/s5inode.h>
#include <cdfs/cdfsnode.h>
#include <nfs/nfs.h>
#include <nfs/rnode.h>
#undef u


/*
 * Local definitions
 */

# if	DUV<50000
#define	COMP_P		void		/* qsort() compare pointer type */
# else	/* DUV>=50000 */
#define	COMP_P		const void	/* qsort() compare pointer type */
# endif	/* DUV<50000 */

typedef	off_t		KA_T;		/* kernel address type for kread() */
#define	KMEM	"/dev/kmem"
#define	LMEMCPY_P	void		/* local memcpy() type */
#define	lmemcpy(d,s,n)	bcopy(s,d,n)	/* local memcpy() function */
#define	MALLOC_P	char		/* malloc() pointer cast */
#define	MALLOC_S	size_t		/* malloc() size cast */
#define	QSORT_P		char		/* qsort() table pointer type */


/*
 * Name list indexes
 */

#define X_FIDS		0		/* lock to vnode map list */
#define X_VNMAXPRIV	1		/* size of largest private fs area */

# if     DUV<30000
#define X_PROCS		2		/* location of proc structures */
#define X_NPROCS	3		/* number of procs configured on sys */
# else	/* DUV>=30000 */
#  if DUV<30200 || DUV>=50000
#define	X_NPID		2		/* number of pidtab[] entries */
#  else	/* DUV>=30200 && DUV<50000 */
#define X_PIDENTRYMASK	2		/* mask to map pid to pid table entry */
#  endif	/* DUV<30200 || DUV>=50000 */
#define X_PROCS		3		/* location of pid to proc table map */
# endif  /* DUV<30000 */


/*
 * Local structure definitions
 */

struct advfsnode {			/* node for VT_MSFS (ADFVS) */

# if	ADVFSV<200
    long	d1[19];
# else	/* ADVFSV>=200 */
#  if   ADVFSV<300
    long	d1[20];
#  else	/* ADVFSV>=300 */
#   if	ADVFSV<400
    long	d1[21];
#   else	/* ADVFSV>=400 */
    long	d1[17];
#   endif	/* ADVFSV>=400 */
#  endif	/* ADVFSV<300 */
# endif	/* ADVFSV<200 */

    ino_t	a_number;
    int		a_seq;

# if	ADVFSV>=500
    long	d3[3];
# else	/* ADVFSV<500 */
    long	d3;
# endif	/* ADVFSV>=500 */

    int		d4;
    dev_t	a_rdev;
    long	a_size;
};

struct l_fsid {				/* file system ID structure for
					 * private mount table data */
	fsid_t fsid;
};

struct l_vfs {				/* local VFS structure */
	struct mount *mount;		/* kernel vnode mount address */
	dev_t dev;			/* device */
	struct l_vfs *next;		/* forward link */
};


/*
 * Local global variables
 */

extern int Kd;				/* kernel memory file descriptor */
extern struct l_vfs *Vfs;		/* local VFS structure table */
extern struct nlist Nl[];		/* kernel symbol table */

#endif	/* defined(DLSLK_H_DIGUNIX) */
