/*
 * main.c -- main lslk function
 *
 * V. Abell
 * Purdue University Computing Center
 */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */
#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: main.c,v 1.6 99/11/10 14:56:01 abe Exp $";
#endif


#include "lslk.h"


/*
 * main() -- the main lslk function
 */

main(argc, argv)
	int argc;				/* argument count */
	char *argv[];				/* arguments */
{
	int c, err, i, lherr;
	struct lhaddr *lh;
	static int nlfa = 0;
	MALLOC_S len;
	char options[64];
	char *path;
	struct stat sb;
	struct llock_info **sp;
/*
 * Get the program name.
 */
	if ((Pn = strrchr(argv[0], '/')))
	    Pn++;
	else
	    Pn = argv[0];
/*
 * Common initialization.
 */
	if ((Mygid = (gid_t)getgid()) != getegid())
	    Setgid = 1;
	if ((Myuid = (uid_t)getuid()) && !geteuid())
	    Setuidroot = 1;
/*
 * Process options.
 */
	(void) sprintf(options, "abhi:%snOp:S:vw",

#if	defined(HASKOPT)
	    "k:"
#else	/* !defined(HASKOPT) */
	    ""
#endif	/* defined(HASKOPT) */

	    );

	err = 0;
	while ((c = getopt(argc, argv, options)) != EOF) {
	    switch (c) {
	    case 'a':		/* -a: AND selection options */
		Oand = 1;
		break;
	    case 'b':		/* -b: avoid kernel blocks */
		Oblock = 1;
		break;
	    case 'h':		/* -h: help */
		Ohelp = 1;
		break;
	    case 'i':		/* -i: specify Internet host names/addresses */
		if (enter_nwad(optarg))
		    err++;
		break;

#if	defined(HASKOPT)
	    case 'k':		/* -k: set optional kernel name list path  */
		Nmlst = optarg;
		break;
#endif	/* defined(HASKOPT) */

	    case 'n':		/* -n: don't convert host names to addresses */
		Oconv = 0;
		break;
	    case 'O':		/* -O avoid fork overhead *RISKY* */
		Oovhd = 1;
		break;
	    case 'p':		/* -p: specify PID numbers */
		if (enter_pid(optarg))
		    err++;
		break;
	    case 'S':		/* -S<value>: set readlink()/stat() timeout
				 *	      value */
		if ((TmLimit = atoi(optarg)) < TMLIMMIN) {
		    (void) fprintf(stderr,
			"%s: WARNING: -S time (%d) changed to %d\n",
			Pn, TmLimit, TMLIMMIN);
		    TmLimit = TMLIMMIN;
		}
		break;
	    case 'v':		/* -v: display version information */
		Overs = 1;
		break;
	    case 'w':		/* -w: suppress warnings */
		Owarn = 0;
		break;
	    case '?':
		err++;
		break;
	    default:
		(void) fprintf(stderr, "%s: unknown option character: %c\n",
		    Pn, (char)c);
		err++;
	    }
	} 
/*
 * Store file selections.
 */
	for (; optind < argc; optind++) {
	    if ((path = Readlink(argv[optind])) == (char *)NULL) {
		err++;
		continue;
	    }
	    if (statsafely(path, &sb) != 0) {
		if (path == argv[optind])
		    (void) fprintf(stderr, "%s: can't stat %s: %s\n",
			Pn, argv[optind], strerror(errno));
		else
		    (void) fprintf(stderr,
			"%s: can't stat %s (symbolic link to %s): %s\n",
			Pn, argv[optind], path, strerror(errno));
		err++;
		continue;
	    }
	/*
	 * Allocate local file table space, as required.
	 */
	    if (NLfile >= nlfa) {
		nlfa += LFILEAU;
		len = (MALLOC_S)(nlfa * sizeof(struct lfile));
		if (Lfile)
		    Lfile = (struct lfile *)realloc(Lfile, len);
		else
		    Lfile = (struct lfile *)malloc(len);
		if (!Lfile) {
		    (void) fprintf(stderr, "%s: no space for %d local files\n",
			Pn, nlfa);
		    Exit(1);
		}
	    }
	/*
	 * Store local file information.
	 */
	    Lfile[NLfile].path = path;
	    Lfile[NLfile].dev = sb.st_dev;
	    Lfile[NLfile].inum = sb.st_ino;
	    Lfile[NLfile].f = 0;
	    NLfile++;
	}
/*
 * Convert specified host names to network numbers; convert specified
 * network numbers to host names.
 */
	if (Oconv && Nwad) {
	    for (i = 0; i < NNwad; i++) {
		if (!Nwad[i].hn && Nwad[i].na) {
		    lh = get_haddr(1, (char *)NULL, Nwad[i].na, &lherr);
		    Nwad[i].chn = Nwad[i].hn = lh->hn;
		    if (lherr && Owarn) {
			(void) fprintf(stderr,
			    "%s: WARNING: can't get name of %s\n",
			    Pn, lh->hn);
		    }
		} else if (Nwad[i].hn && !Nwad[i].na) {
		    lh = get_haddr(0, Nwad[i].hn, (unsigned long)0, &lherr);
		    Nwad[i].na = lh->na;
		    Nwad[i].chn = lh->hn;
		    if (lherr && Owarn) {
			(void) fprintf(stderr,
			   "%s: WARNING: can't get address of %s\n",
			   Pn, lh->hn);
		    }
		}
	    }
	}
/*
 * Check argument processing results.
 */
	if (err || Ohelp || Overs)
	    usage(err);
/*
 * Identify the selection options.
 */
	Selopt = 0;
	if (Nwad)
	    Selopt |= SELNWAD;
	if (Lfile)
	    Selopt |= SELFILE;
	if (Pid)
	    Selopt |= SELPID;
/*
 * Construct the local mount table.
 */
	if (readmnt())
	    Exit(1);
/*
 * Do dialect-specific initialization.
 */
	(void) initialize();
/*
 * Gather local lock information and print it.
 */
	(void) gather_lock_info();
/*
 * Sort -- or at least build a pointer array to the lock information.
 */
	if (NLockU) {
	    len = (MALLOC_S)(NLockU * sizeof(struct llock_info *));
	    if (!(sp = (struct llock_info **)malloc(len))) {
		(void) fprintf(stderr,
		    "%s: no space for lock info pointers\n", Pn);
		Exit(1);
	    }
	    for (i = 0; i < NLockU; i++) {
		sp[i] = &Lock[i];
	    }
	    qsort((QSORT_P *)sp, (size_t)NLockU,
		(size_t)sizeof(struct llock_info *), comppid);
	    (void) print_lock_info(sp);
	}
/*
 * If file paths were specified, see if all were located and return
 * a 1 if they weren't.
 */
	if (NLfile) {
	    for (i = 0; i < NLfile; i++) {
		if (!Lfile[i].f)
		    Exit(1);
	    }
	}
	Exit(0);
}


/*
 * comppid() - compare PIDs
 */

int
comppid(a1, a2)
	COMP_P *a1, *a2;
{
	struct llock_info **p1 = (struct llock_info **)a1;
	struct llock_info **p2 = (struct llock_info **)a2;

	if ((*p1)->pid < (*p2)->pid)
		return(-1);
	if ((*p1)->pid > (*p2)->pid)
		return(1);
	return(0);
}
