#!/usr/bin/python
# -*- coding: UTF-8 -*-

import unicodedata

from translate import trans
from tokens import make_tokens, IsSlovak

class Word:
    def __init__(self, token, ws):
        self.token = token
        self.ws = ws

    def __str__(self):
        return self.ws+self.token


def parse_text(text):
    for tok, ws in make_tokens(text):
        yield Word(tok, ws)

def words2text(words):
    r = ''
    for w in words:
        r += unicode(w)
    return r

def translate_words(words):
    for w in words:
        orig = w.token
        if IsSlovak(orig):
            nw = Word(trans(orig), w.ws)
        else:
            nw = w
        yield nw

def translate_text(text, nfkd='none'):
    words =  parse_text(text)
    words = translate_words(words)
    text = words2text(words)
    if nfkd=='all':
        text = unicodedata.normalize('NFKD', text)
    elif nfkd=='hack':
        text = text.replace(u'ď', u'd\N{COMBINING CARON}').replace(u'ť', u't\N{COMBINING CARON}')
    return text

if __name__ == '__main__':
    import fileinput
    for line in fileinput.input():
        t =  translate_text(line.decode('utf-8'))
        print t
        
            
