%define version 3.0.4
%define kversion 

Summary: ldiskfs backend file system
Name: lustre-ldiskfs
Version: %{version}
Release: 
License: GPL
Group: Development/Kernel
Source: lustre-ldiskfs-%{version}.tar.gz
URL: http://clusterfs.com/
BuildRoot: %{_tmppath}/lustre-ldiskfs-%{version}-root
Requires: modutils >= 2.4.10

%description
Provides the ldiskfs backend file system kernel module, used by
servers in the Lustre file system, for Linux %{kversion}.

%prep
%setup -q

%build
# if RPM_BUILD_NCPUS unset, set it
if [ -z "$RPM_BUILD_NCPUS" ] ; then
    RPM_BUILD_NCPUS=$(egrep -c "^cpu[0-9]+" /proc/stat 2>/dev/null || echo 0 :)
    if [ $RPM_BUILD_NCPUS -eq 0 ] ; then
        RPM_BUILD_NCPUS=1
    fi
    if [ $RPM_BUILD_NCPUS -gt 8 ] ; then
        RPM_BUILD_NCPUS=8
    fi
fi

rm -rf $RPM_BUILD_ROOT

# Set an explicit path to our Linux tree, if we can.
cd $RPM_BUILD_DIR/lustre-ldiskfs-%{version}
./configure '--prefix=/usr' '--disable-modules' '--disable-utils' '--disable-liblustre' '--disable-tests' '--disable-doc' '--with-lustre-hack' '--with-sockets' '--cache-file=/dev/null' '--srcdir=.' %{?configure_flags:configure_flags} \
	--sysconfdir=%{_sysconfdir} \
	--mandir=%{_mandir} \
	--libdir=%{_libdir}
make -j $RPM_BUILD_NCPUS -s

%install
make install DESTDIR=$RPM_BUILD_ROOT

%files
%attr(-, root, root) /lib/modules/%{kversion}/kernel/fs/lustre-ldiskfs

%post
if [ -f /boot/System.map-%{kversion} ]; then
	depmod -ae -F /boot/System.map-%{kversion} %{kversion} || exit 0
else
	depmod -ae %{kversion} || exit 0
fi

%postun
if [ -f /boot/System.map-%{kversion} ]; then
	depmod -ae -F /boot/System.map-%{kversion} %{kversion} || exit 0
else
	depmod -ae %{kversion} || exit 0
fi

%clean
rm -rf $RPM_BUILD_ROOT
