//
//  libavg - Media Playback Engine. 
//  Copyright (C) 2003-2006 Ulrich von Zadow
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//  Current versions can be found at www.libavg.de
//

#ifndef _InfoVideoMsg_H_
#define _InfoVideoMsg_H_

#include "VideoMsg.h"

#include "../graphics/Bitmap.h"

namespace avg {

class InfoVideoMsg: public VideoMsg {
    public:
        InfoVideoMsg(IntPoint Size, int NumFrames, double FPS, PixelFormat PF);
        virtual ~InfoVideoMsg();

        IntPoint getSize() const;
        int getNumFrames() const;
        double getFPS() const;
        PixelFormat getPF() const;

    private:
        IntPoint m_Size;
        int m_NumFrames;
        double m_FPS;
        PixelFormat m_PF;
};

typedef boost::shared_ptr<InfoVideoMsg> InfoVideoMsgPtr;

}
#endif 

