/*
* libcafix - communicates with CASIO graphing calculators.
* Copyright (C) 2001  Gran Weinholt <weinholt@linux.nu>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* $Id: data.c,v 1.2 2001/07/28 17:46:06 weinholt Exp $
*/
#include <cafix.h>
#include <stdlib.h>
#include <string.h>

static char rcsid[] = "$Id: data.c,v 1.2 2001/07/28 17:46:06 weinholt Exp $\n";

void cafix_data_generate(cafixdata *data, void *insert_data)
{
    /*
     * Try to generate data->data from insert_data.
     */
    if (data->format != FMT_VARIABLE) {
	data->status = STAT_NOT_IMPLEMENTED;
	data->data = malloc(1);
	return;
    }

    switch (data->datatype) {
    case DATA_VM:
	if (data->interactive == 1) {
	    double sliff;

	    memcpy(&sliff, insert_data, sizeof(sliff));
	    if (!(data->data = calloc(1, 15)))		// XXX: allocates more than needed
		return;	// XXX: if it failed then why bother?
	    data->length = 14;
	    memcpy(data->data, "\0\1\0\1", 4);
	    data->data[4] = sliff / 10;
	    data->data[5] = (sliff - (10 * (unsigned char) (sliff / 10))) * 16;
	    data->data[12] = 1;
	    data->data[13] = 1;
	    return;
	}
	//no break;
    default:
	data->status = STAT_NOT_IMPLEMENTED;
	data->data = malloc(1);
	break;
    }
}

double cafix_data_get_double_value(cafixdata *data)
{
    /* FIXME: this is by no means fully right */
    if (data->datatype == DATA_VM && data->interactive == 1)
	return (data->data[4] * 10) + (data->data[5] / 16);

    return -1;
}

void cafix_list_append(cafixdata *list, cafixdata *data)
{
    cafixdata *fnord = list;

    while (fnord->next != NULL)
	fnord = (cafixdata *)fnord->next;
    fnord->next = data;
}

void cafix_list_free_all(cafixdata *list)
{
    /*
     * Free everything we can get our hands on. 
     * FIXME: does this leak?
     */
    cafixdata *foo, *bar;

    foo = list;
    while (foo != NULL) {
	if (foo->name != NULL) free(foo->name);
	if (foo->password != NULL) free(foo->password);
	if (foo->data != NULL) free(foo->data);
	bar = foo;
	foo = foo->next;
	free(bar);
    }
}
