/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#include "s-line.h"

#include <ccc/cc-line.h>

START_TEST(test_line_bounds_none)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);

	/* FIXME: make sure that a newly created CcLine doesn't have a bounding box */
}
END_TEST

START_TEST(test_line_bounds_single_line)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);

	/* FIXME: make sure that adding a signle point creates the bounding box */
}
END_TEST

START_TEST(test_line_bounds_single_move)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);

	/* FIXME: make sure that adding a signle point creates the bounding box */
}
END_TEST

START_TEST(test_line_bounds_multiple_points)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);

	/* FIXME: make sure that the bounding box is correct when adding multiple points */
}
END_TEST

START_TEST(test_line_bounds_multiple_moves)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);

	/* FIXME: make sure that multiple moves don't change the bounding box */
}
END_TEST

TCase*
tcase_line_all_bounds (void)
{
	TCase* self = tcase_create ("All-Bounds Handling");
	tcase_add_test (self, test_line_bounds_none);
	tcase_add_test (self, test_line_bounds_single_line);
	tcase_add_test (self, test_line_bounds_single_move);
	tcase_add_test (self, test_line_bounds_multiple_points);
	tcase_add_test (self, test_line_bounds_multiple_moves);
	return self;
}

