class AddressManager
	include Enumerable

	def initialize( file )
		@file      = file
		@addresses = []
		line       = nil
		address    = nil

		f = File.new @file
		f.readlines.each do | line |
			line.chomp!
			next if line == ""

			data            = line.split(/\t/,5)
			address         = Address.new
			address.name    = data.shift
			address.address = data.shift
			address.gender  = data.shift
			address.country = data.shift
			address.comment = data.shift
			@addresses << address
		end
		f.close
	end

	def []( index )
		@addresses[index]
	end

	def []=( index, value )
		@addresses[index] = value
	end

	def <<( address )
		@addresses << address
	end
		
	def each
		@addresses.each do | address |
			unless address.delete?
				yield address
			end
		end
	end

	def write
		f = File.new( @file, 'w' )
		f.rewind
		f.write to_tsv
		f.close
	end

	def to_tsv
		array = []
		self.each do | address |
			array << address.to_tsv
		end
		array.join "\n"
	end
end


class Address
	attr_accessor :name, :address, :gender, :country, :language, :comment, \
		:is_delete

	def initialize
		@is_delete = false
	end

	def delete
		@is_delete = true
	end

	def delete?
		@is_delete
	end

	def each
		array = [@name,@address,@gender,@country,@comment]
		array.each do | data |
			yield data
		end
	end

	def to_tsv
		str = ''
		self.each do | data |
			str << "#{data}\t"
		end
		str
	end
end



if __FILE__ == $0 then

file = '../addresses.txt'

am = AddressManager.new file
p am

end
