/***************************************************************************
                           ciconv.h  -  DCLib C++ iconv wrapper
                             -------------------
    begin                : Thu Sep 20 2007
    copyright            : (C) 2007 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CICONV_H
#define CICONV_H
 
/**
 * @author Edward Sheldrake
 */

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>
#include <dclib/core/cstring.h>

#include <iconv.h>

class DLL_EXPORT CIconv : public CObject {

public:
	/** Constructor using specified encodings */
	CIconv( CString from, CString to );
	/** Destructor */
	virtual ~CIconv();
	
	/** encode text between the encodings */
	CString encode( CString text );

private:
	/** iconv structure used for encoding */
	iconv_t cd;
};
 
#endif // CICONV_H
