/*
     This file is part of libextractor.
     (C) 2002, 2003, 2004, 2005 Vidyut Samanta and Christian Grothoff

     libextractor is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     libextractor is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with libextractor; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
 */

#include "config.h"
#include <extractor.h>
#include <jni.h>

/* gcj's jni.h does not define JNIEXPORT/JNICALL (at least
 * not in my version).  Sun defines it to 'empty' on GNU/Linux,
 * so that should work */
#ifndef JNIEXPORT
#define JNIEXPORT
#endif
#ifndef JNICALL
#define JNICALL
#endif

#include "org_gnunet_libextractor_Extractor.h"

#define HIGHEST_TYPE_NUMBER EXTRACTOR_getHighestKeywordTypeNumber()

/*
 * Class:     org_gnunet_libextractor_Extractor
 * Method:    loadDefaultInternal
 * Signature: ()J
 */
JNIEXPORT jlong JNICALL 
Java_org_gnunet_libextractor_Extractor_loadDefaultInternal(JNIEnv * env,
							   jclass c) {
  return (jlong) (long) EXTRACTOR_loadDefaultLibraries();
}

/*
 * Class:     org_gnunet_libextractor_Extractor
 * Method:    unloadInternal
 * Signature: (J)V
 */
JNIEXPORT void JNICALL 
Java_org_gnunet_libextractor_Extractor_unloadInternal(JNIEnv * env,
						      jclass c,
						      jlong arg) {
  EXTRACTOR_removeAll((EXTRACTOR_ExtractorList*) (long) arg);
}

/*
 * Class:     org_gnunet_libextractor_Extractor
 * Method:    extractInternal
 * Signature: (JLjava/lang/String;)J
 */
JNIEXPORT jlong JNICALL 
Java_org_gnunet_libextractor_Extractor_extractInternal(JNIEnv * env,
						       jclass c,
						       jlong arg,
						       jstring f) {
  const char * fname;
  jboolean bo;
  jlong ret;

  bo = JNI_FALSE;
  fname = (*env)->GetStringUTFChars(env, f, &bo);
  ret = (jlong) (long) EXTRACTOR_getKeywords((EXTRACTOR_ExtractorList*) (long) arg,
					     fname);
  (*env)->ReleaseStringUTFChars(env, f, fname);
  return ret;
}

/*
 * Class:     org_gnunet_libextractor_Extractor
 * Method:    freeInternal
 * Signature: (J)V
 */
JNIEXPORT void JNICALL 
Java_org_gnunet_libextractor_Extractor_freeInternal(JNIEnv * env,
						    jclass c,
						    jlong list) {
  EXTRACTOR_freeKeywords( (EXTRACTOR_KeywordList*) (long) list);
}

/*
 * Class:     org_gnunet_libextractor_Extractor
 * Method:    typeInternal
 * Signature: (J)I
 */
JNIEXPORT jint JNICALL 
Java_org_gnunet_libextractor_Extractor_typeInternal(JNIEnv * env,
						    jclass c,
						    jlong list) {
  if (list == 0)
    return -1; /* error! */
  return ((EXTRACTOR_KeywordList*) (long) list)->keywordType;
}

/*
 * Class:     org_gnunet_libextractor_Extractor
 * Method:    keywordInternal
 * Signature: (J)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL 
Java_org_gnunet_libextractor_Extractor_keywordInternal(JNIEnv * env,
						       jclass c,
						       jlong list) {
  char * str;
  if (list == 0)
    return NULL; /* error! */
  str = ((EXTRACTOR_KeywordList*) (long) list)->keyword;
  return (*env)->NewStringUTF(env, str);
}

/*
 * Class:     org_gnunet_libextractor_Extractor
 * Method:    nextInternal
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL 
Java_org_gnunet_libextractor_Extractor_nextInternal(JNIEnv * env,
						    jclass j,
						    jlong list) {
  if (list == 0)
    return 0; /* error! */
  return (jlong) (long) ((EXTRACTOR_KeywordList*) (long) list)->next;
}

/*
 * Class:     org_gnunet_libextractor_Extractor
 * Method:    getTypeAsStringInternal
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL 
Java_org_gnunet_libextractor_Extractor_getTypeAsStringInternal(JNIEnv * env,
							       jclass c,
							       jint type) {
  const char * str;
  if ( (type < 0) || (type > HIGHEST_TYPE_NUMBER) )
    return NULL; /* error! */
  str = EXTRACTOR_getKeywordTypeAsString((EXTRACTOR_KeywordType)type);
  if (str == NULL)
    return NULL;
  return (*env)->NewStringUTF(env,
			      str);
}


/*
 * Class:     org_gnunet_libextractor_Extractor
 * Method:    getVersionInternal
 * Signature: ()I
 */
JNIEXPORT jint JNICALL 
Java_org_gnunet_libextractor_Extractor_getVersionInternal(JNIEnv * env,
							  jclass c) {
  return EXTRACTOR_VERSION;
}

/*
 * Class:     org_gnunet_libextractor_Extractor
 * Method:    getMaxTypeInternal
 * Signature: ()I
 */
JNIEXPORT jint JNICALL 
Java_org_gnunet_libextractor_Extractor_getMaxTypeInternal(JNIEnv * env,
							  jclass c) {
  return HIGHEST_TYPE_NUMBER;
}

/*
 * Class:     org_gnunet_libextractor_Extractor
 * Method:    unloadPlugin
 * Signature: (JLjava/lang/String;)J
 */
JNIEXPORT jlong JNICALL 
Java_org_gnunet_libextractor_Extractor_unloadPlugin(JNIEnv * env,
									  jclass c,
									  jlong handle,
									  jstring name) {
  const char * lname;
  jboolean bo;
  jlong ret;

  bo = JNI_FALSE;
  lname = (*env)->GetStringUTFChars(env, name, &bo);
  ret = (jlong) (long) EXTRACTOR_removeLibrary((EXTRACTOR_ExtractorList*) (long) handle,
					       lname);
  (*env)->ReleaseStringUTFChars(env, name, lname);
  return ret;
}

/*
 * Class:     org_gnunet_libextractor_Extractor
 * Method:    loadPlugin
 * Signature: (JLjava/lang/String;Z)J
 */
JNIEXPORT jlong JNICALL 
Java_org_gnunet_libextractor_Extractor_loadPlugin(JNIEnv * env,
						  jclass c,
						  jlong handle,
						  jstring name,
						  jboolean place) {
  const char * lname;
  jboolean bo;
  jlong ret;

  bo = JNI_FALSE;
  lname = (*env)->GetStringUTFChars(env, name, &bo);
  if (place == JNI_TRUE) {
    ret = (jlong) (long) EXTRACTOR_addLibraryLast((EXTRACTOR_ExtractorList*) (long) handle,
						  lname);
  } else {
    ret = (jlong) (long) EXTRACTOR_addLibrary((EXTRACTOR_ExtractorList*) (long) handle,
					      lname);
  }
  (*env)->ReleaseStringUTFChars(env, name, lname);
  return ret;
}

