/**
 * @file libgalago-gtk/galago-gtk-presence-menu-item.h Presence menu item widget
 *
 * @Copyright (C) 2004-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_PRESENCE_MENU_ITEM_H_
#define _GALAGO_GTK_PRESENCE_MENU_ITEM_H_

typedef struct _GalagoGtkPresenceMenuItem      GalagoGtkPresenceMenuItem;
typedef struct _GalagoGtkPresenceMenuItemClass GalagoGtkPresenceMenuItemClass;
typedef struct _GalagoGtkPresenceMenuItemPriv  GalagoGtkPresenceMenuItemPriv;

#include <libgalago/galago.h>
#include <gtk/gtkimagemenuitem.h>

#define GALAGO_GTK_TYPE_PRESENCE_MENU_ITEM (galago_gtk_presence_menu_item_get_type())
#define GALAGO_GTK_PRESENCE_MENU_ITEM(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_GTK_TYPE_PRESENCE_MENU_ITEM, GalagoGtkPresenceMenuItem))
#define GALAGO_GTK_PRESENCE_MENU_ITEM_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_GTK_TYPE_PRESENCE_MENU_ITEM, GalagoGtkPresenceMenuItemClass))
#define GALAGO_GTK_IS_PRESENCE_MENU_ITEM(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_GTK_TYPE_PRESENCE_MENU_ITEM))
#define GALAGO_GTK_IS_PRESENCE_MENU_ITEM_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_GTK_TYPE_PRESENCE_MENU_ITEM))
#define GALAGO_GTK_PRESENCE_MENU_ITEM_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS ((obj), GALAGO_GTK_TYPE_PRESENCE_MENU_ITEM, GalagoGtkPresenceMenuItemClass))

struct _GalagoGtkPresenceMenuItem
{
	GtkImageMenuItem parent_object;

	GalagoGtkPresenceMenuItemPriv *priv;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

struct _GalagoGtkPresenceMenuItemClass
{
	GtkImageMenuItemClass parent_class;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

G_BEGIN_DECLS

GType galago_gtk_presence_menu_item_get_type(void);

GtkWidget *galago_gtk_presence_menu_item_new(GalagoAccount *account);

void galago_gtk_presence_menu_item_set_account(GalagoGtkPresenceMenuItem *item,
											   GalagoAccount *account);
void galago_gtk_presence_menu_item_set_person(GalagoGtkPresenceMenuItem *item,
											  GalagoPerson *person);
void galago_gtk_presence_menu_item_set_dim_idle(GalagoGtkPresenceMenuItem *item,
												gboolean dim_idle);
void galago_gtk_presence_menu_item_set_show_idle_times(GalagoGtkPresenceMenuItem *item,
													   gboolean show_idle_times);

GalagoAccount *galago_gtk_presence_menu_item_get_account(const GalagoGtkPresenceMenuItem *item);
GalagoPerson *galago_gtk_presence_menu_item_get_person(const GalagoGtkPresenceMenuItem *item);
gboolean galago_gtk_presence_menu_item_get_dim_idle(const GalagoGtkPresenceMenuItem *item);
gboolean galago_gtk_presence_menu_item_get_show_idle_times(const GalagoGtkPresenceMenuItem *item);

G_END_DECLS

#endif /* _GALAGO_GTK_PRESENCE_MENU_ITEM_H_ */
