/* $Id: init.c,v 1.9 2005/09/14 22:57:04 cegger Exp $
******************************************************************************

   LibGGIMisc implementation for "svgalib" target -- Initialization.

   Copyright (c) 2001      Brian S. Julin	bri@calyx.com
   Copyright (c) 1998-2000 Marcus Sundberg      marcus@ggi-project.org 
   
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   The above copyright notice applies to all files in this package, unless 
   explicitly stated otherwise in the file itself or in a file named COPYING 
   in the same directory as the file.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


******************************************************************************
*/

#include "config.h"
#include "svgalibggimisc.h"

#if defined(__linux__) && defined (WANT_DANGEROUS_SPLITLINE)
#include <asm/io.h>
#define MISCr   0x03CC
#define MISCw   0x03C2
#define CRTIm   0x03B4
#define CRTIc   0x03D4
#define CRTDm   0x03B5
#define CRTDc   0x03D5
#define MISC_COLOR_IO   0x01
#endif

static int GGIopen(ggi_visual *vis, struct ggi_dlhandle *dlh,
		   const char *args, void *argptr, uint32_t *dlret)
{
	struct svgalibggimisc_priv *priv;

	/*-* Initialize target-private data structure */
	priv = malloc(sizeof(struct svgalibggimisc_priv));
	if (priv == NULL) {
		*dlret = GGI_DL_ERROR;
		return GGI_ENOMEM;
	}
	LIBGGI_GGIMISCEXT(vis)->priv = priv;

	/*-* Hook in target functions */

	LIBGGI_GGIMISCEXT(vis)->waitraypos = GGIMISC_Svgalib_WaitRayPos;

	/* Not implemented 
	LIBGGI_GGIMISCEXT(vis)->getraypos = GGIMISC_Svgalib_GetRayPos;
	*/

#if defined(__linux__) && defined (WANT_DANGEROUS_SPLITLINE)
        {
		int tmp = inb(MISCr);
		outb(tmp, MISCw);
		if (tmp & MISC_COLOR_IO) { 
			SVGAMISC_PRIV(vis)->CRTI = CRTIc;
			SVGAMISC_PRIV(vis)->CRTD = CRTDc; 
		} else {
			SVGAMISC_PRIV(vis)->CRTI = CRTIm;
			SVGAMISC_PRIV(vis)->CRTD = CRTDm;
		}	/* if */
        }
	LIBGGI_GGIMISCEXT(vis)->setsplitline = GGIMISC_Svgalib_SetSplitline;
#endif

	/*-* Apply initial values */

	*dlret = GGI_DL_EXTENSION | GGI_DL_OPDISPLAY;
	return 0;
}	/* GGIopen */


static int GGIclose(ggi_visual *vis, struct ggi_dlhandle *dlh)
{
	/*-* Free target-private structure */
	free(SVGALIBGGIMISC_PRIV(vis));

	LIBGGI_GGIMISCEXT(vis)->priv = NULL;

	return 0;
}	/* GGIclose */


EXPORTFUNC int GGIMISCdl_svgalib_ggimisc(int func, void **funcptr);

int GGIMISCdl_svgalib_ggimisc(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = (void *)GGIopen;
		return 0;

	case GGIFUNC_exit:
		*funcptr = NULL;
		return 0;

	case GGIFUNC_close:
		*funcptr = (void *)GGIclose;
		return 0;

	default:
		*funcptr = NULL;
	}	/* switch */

	return GGI_ENOTFOUND;
}	/* GGIMISCdl_svgalib_ggimisc */


/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
