=begin
= Eigensystems

== Modules and classes

* GSL
  * Eigen
    * EigenValues < Vector
    * EigenVectors < Matrix
    * Symm (Module)
      * Workspace (Class)
    * Symmv (Module)
      * Workspace (Class)
    * Nonsymm (Module, > GSL-1.9)
      * Workspace (Class)
    * Nonsymmv (Module, > GSL-1.9)
      * Workspace (Class)
    * Herm (Module)
      * Workspace (Class)
    * Hermv (Module)
      * Workspace (Class)
      * Vectors < Matrix::Complex

== Real Symmetric Matrices, GSL::Eigen::Symm module
=== Workspace classes
--- GSL::Eigen::Symm::Workspace.alloc(n)
--- GSL::Eigen::Symmv::Workspace.alloc(n)
--- GSL::Eigen::Herm::Workspace.alloc(n)
--- GSL::Eigen::Hermv::Workspace.alloc(n)

=== Methods to solve eigensystems
--- GSL::Eigen::symm(A)
--- GSL::Eigen::symm(A, workspace)
--- GSL::Matrix#eigen_symm
--- GSL::Matrix#eigen_symm(workspace)
    These methods compute the eigenvalues of the real symmetric matrix. 
    The workspace object ((|workspace|)) can be omitted.

--- GSL::Eigen::symmv(A)
--- GSL::Matrix#eigen_symmv
    These methods compute the eigenvalues and eigenvectors of the real symmetric 
    matrix, and return an array of two elements:
    The first is a (({GSL::Vector})) object which stores all the eigenvalues. 
    The second is a (({GSL::Matrix object})), whose columns contain 
    eigenvectors.

    (1) Singleton method of the (({GSL::Eigen})) module, (({GSL::Eigen::symm}))

          m = GSL::Matrix.alloc([1.0, 1/2.0, 1/3.0, 1/4.0], [1/2.0, 1/3.0, 1/4.0, 1/5.0],
                             [1/3.0, 1/4.0, 1/5.0, 1/6.0], [1/4.0, 1/5.0, 1/6.0, 1/7.0])
          eigval, eigvec = Eigen::symmv(m)

    (2) Instance method of (({GSL::Matrix})) class

          eigval, eigvec = m.eigen_symmv

== Complex Hermitian Matrices
--- GSL::Eigen::herm(A)
--- GSL::Eigen::herm(A, workspace)
--- GSL::Matrix::Complex#eigen_herm
--- GSL::Matrix::Complex#eigen_herm(workspace)
    These methods compute the eigenvalues of the complex hermitian matrix. 

--- GSL::Eigen::hermv(A)
--- GSL::Eigen::hermv(A, workspace)
--- GSL::Matrix::Complex#eigen_hermv
--- GSL::Matrix::Complex#eigen_hermv(workspace

== Real Nonsymmetric Matrices (> GSL-1.9)

--- GSL::Eigen::Nonsymm.alloc(n)
    This allocates a workspace for computing eigenvalues of n-by-n real 
    nonsymmetric matrices. The size of the workspace is O(2n).

--- GSL::Eigen::Nonsymm::params(compute_t, balance, wspace)
--- GSL::Eigen::Nonsymm::Workspace#params(compute_t, balance)
    This method sets some parameters which determine how the eigenvalue 
    problem is solved in subsequent calls to (({GSL::Eigen::nonsymm})).
    If ((|compute_t|)) is set to 1, the full Schur form (({T})) will be 
    computed by gsl_eigen_nonsymm. If it is set to 0, (({T})) will not be 
    computed (this is the default setting). 
    Computing the full Schur form (({T})) requires approximately 1.5-2 times 
    the number of flops.

    If ((|balance|)) is set to 1, a balancing transformation is applied to 
    the matrix prior to computing eigenvalues. This transformation is designed 
    to make the rows and columns of the matrix have comparable norms, and can 
    result in more accurate eigenvalues for matrices whose entries vary widely 
    in magnitude. See section Balancing for more information. Note that the
    balancing transformation does not preserve the orthogonality of the Schur 
    vectors, so if you wish to compute the Schur vectors with 
    (({GSL::Eigen::nonsymm_Z})) you will obtain the Schur vectors of the 
    balanced matrix instead of the original matrix. The relationship will be 
    where Q is the matrix of Schur vectors for the balanced matrix, and (({D})) 
    is the balancing transformation. Then (({GSL::Eigen::nonsymm_Z})) will 
    compute a matrix (({Z})) which satisfies with (({Z = D Q})). 
    Note that (({Z})) will not be orthogonal. For this reason, balancing is
    not performed by default.

--- GSL::Eigen::nonsymm(m, eval, wspace)
--- GSL::Eigen::nonsymm(m)
--- GSL::Matrix#eigen_nonsymm()
--- GSL::Matrix#eigen_nonsymm(wspace)
--- GSL::Matrix#eigen_nonsymm(eval, wspace)
    These methods compute the eigenvalues of the real nonsymmetric matrix (({m})) 
    and return them, or store in the vector ((|eval|)) if it given. 
    If (({T})) is desired, it is stored in (({m})) on output, however the lower 
    triangular portion will not be zeroed out. Otherwise, on output, the diagonal 
    of (({m})) will contain the 1-by-1 real eigenvalues and 2-by-2 complex 
    conjugate eigenvalue systems, and the rest of (({m})) is destroyed. 

--- GSL::Eigen::nonsymm_Z(m, eval, Z, wspace)
--- GSL::Eigen::nonsymm_Z(m)
--- GSL::Matrix#eigen_nonsymm_Z()
--- GSL::Matrix#eigen_nonsymm(eval, Z, wspace)
    These methods are identical to (({GSL::Eigen::nonsymm})) except they also 
    compute the Schur vectors and return them (or store into (({Z}))).

--- GSL::Eigen::Nonsymmv.alloc(n)
    Allocates a workspace for computing eigenvalues and eigenvectors 
    of n-by-n real nonsymmetric matrices. The size of the workspace is O(5n).
--- GSL::Eigen::nonsymm(m)
--- GSL::Eigen::nonsymm(m, wspace)
--- GSL::Eigen::nonsymm(m, eval, evec)
--- GSL::Eigen::nonsymm(m, eval, evec, wspace)
--- GSL::Matrix#eigen_nonsymmv()
--- GSL::Matrix#eigen_nonsymmv(wspace)
--- GSL::Matrix#eigen_nonsymmv(eval, evec)
--- GSL::Matrix#eigen_nonsymmv(eval, evec, wspace)
    Compute eigenvalues and right eigenvectors of the n-by-n real nonsymmetric 
    matrix. The computed eigenvectors are normalized to have Euclidean norm 1.

== Sorting Eigenvalues and Eigenvectors
--- GSL::Eigen::symmv_sort(eval, evec, type = GSL::Eigen::SORT_VAL_ASC)
--- GSL::Eigen::Symmv::sort(eval, evec, type = GSL::Eigen::SORT_VAL_ASC)
    These methods simultaneously sort the eigenvalues stored in the vector 
    ((|eval|)) and the corresponding real eigenvectors stored in the 
    columns of the matrix ((|evec|)) into ascending or descending order 
    according to the value of the parameter ((|type|)),
      * (({GSL::Eigen::SORT_VAL_ASC}))
        ascending order in numerical value
      * (({GSL::Eigen::SORT_VAL_DESC}))
        escending order in numerical value
      * (({GSL::Eigen::SORT_ABS_ASC}))
        scending order in magnitude
      * (({GSL::Eigen::SORT_ABS_DESC}))
        descending order in magnitude
    The sorting is carried out ((|in-place|)).

--- GSL::Eigen::hermv_sort(eval, evec, type = GSL::Eigen::SORT_VAL_ASC)
--- GSL::Eigen::Hermv::sort(eval, evec, type = GSL::Eigen::SORT_VAL_ASC)
    These methods simultaneously sort the eigenvalues stored in the vector 
    ((|eval|)) and the corresponding complex eigenvectors stored in the columns 
    of the matrix ((|evec|)) into ascending or descending order according 
    to the value of the parameter ((|type|)) as shown above.

((<prev|URL:linalg.html>))
((<next|URL:fft.html>))

((<Reference index|URL:ref.html>))
((<top|URL:index.html>))

=end
