/*******************************************************************************************************************************************
 cdemomoduleserialize.c

 simple compilation directives :
 c++ -Wno-multichar -O2 -o serialize `pkg-config --cflags libgtkol-1.2` cdemomoduleserialize.c `pkg-config --libs libgtkol-1.2`

 This sample demonstrates gtkol serialization capabilities.
*******************************************************************************************************************************************/

#include "cdemomodule.h"

const static CString DEMO_XML_DUMP ("/tmp/gtkol-demo.xml");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDemoFormSerializeListener definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoFormSerializeListener : public CFormListener
{
	virtual void				OnClose		(CObject *inSender);
	SECTION_DYNAMIC_METACLASS;
};
DECLARE_DYNAMIC_METACLASS ('_osz', CDemoFormSerializeListener, CFormListener);
RESOLVE_DYNAMIC_METACLASS (CDemoFormSerializeListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// CFileExitMenuItemListener definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CFileExitMenuItemListener : public CMenuItemListener
{
	virtual void				OnClick		(CObject *inSender);
	SECTION_DYNAMIC_METACLASS;
};
DECLARE_DYNAMIC_METACLASS ('_ext', CFileExitMenuItemListener, CMenuItemListener);
RESOLVE_DYNAMIC_METACLASS (CFileExitMenuItemListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDemoModuleSerialize definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoModuleSerialize : public CDemoModule
{
	public :
		
		CDemoModuleSerialize 		();

		virtual TDemoModuleDescription 	GetDescription 	() const;
		virtual void 			Run 		(CApplication *inOwner);
		virtual void 			Stop 		();

		void				PaintXml	();

	public :

		CForm *				m_Form;
		CTextView *			m_TextView;
		CToolButton *			m_ToolButtonSave;
		CToolButton *			m_ToolButtonDelete;
		CStatusBar *			m_StatusBar;

		static CDemoModuleSerialize * 	m_DemoModuleInstance;

		SECTION_DYNAMIC_METACLASS;
};
DECLARE_DYNAMIC_METACLASS ('dosz', CDemoModuleSerialize, CDemoModule);
RESOLVE_DYNAMIC_METACLASS (CDemoModuleSerialize);

//-----------------------------------------------------------------------------------------------------------------------------------------
// OnClose event handler
//-----------------------------------------------------------------------------------------------------------------------------------------
void CDemoFormSerializeListener::OnClose (CObject *inSender)
{
	CXMLDocument (DEMO_XML_DUMP, XML_WRITE, CString("gtkol-demo")) << *inSender;

	if (CDemoModuleSerialize::m_DemoModuleInstance -> m_TextView == NULL) return;
	::system (("xml-reader " + DEMO_XML_DUMP + " > " + DEMO_XML_DUMP + ".sort").Get());
	CFile File (DEMO_XML_DUMP + ".sort", CString("rb")); 
	*(CDemoModuleSerialize::m_DemoModuleInstance -> m_TextView) << File;
	CDemoModuleSerialize::m_DemoModuleInstance -> m_TextView -> ApplyTag (CTextView::m_GtkTextTagMonospace);
	CDemoModuleSerialize::m_DemoModuleInstance -> PaintXml ();
	CDemoModuleSerialize::m_DemoModuleInstance -> m_StatusBar -> 
		SetCaption (CString("You can now play with the xml dump file."));
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// OnClick event handler
//-----------------------------------------------------------------------------------------------------------------------------------------
void CFileExitMenuItemListener::OnClick (CObject *inSender)
{
	static_cast <CForm *> (static_cast <CMenuItem *> (inSender) -> GetOwner (__metaclass(CForm))) -> Close ();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// demo module dynamic link
//-----------------------------------------------------------------------------------------------------------------------------------------

CDemoModuleSerialize * CDemoModuleSerialize::m_DemoModuleInstance = NULL;

const static TDemoModuleDescription DEMO_MODULE_DESCRIPTION = 
{ 
	CString ("Serialization"), 
	CString ("This demonstration shows simple serialization capabilities. When the demo closes, it dumps its state into\n") +
		 "an xml file. When it is launched again, the whole demo is instanciated and reloaded from the dumped file.\n" + 
		 "You can use the above Extra notebook tab to access the xml content and play with before launching again.\n\n" +
		 "The shown source code does not realy correspond to the one that is executed here because the demo module dumps only\n" +
		 "the form, not the whole application as its purpose is not to dump the full gtkol demo application !\n" +
		 "Please refer to the gtkol devel documentation about serialization to have details about the process.\n\n" + 
		 "To view a more complex and powerfull serialization code sample, see the gtkol-dump.c file installed by the\n" +
		 "libgtkol-devel rpm.",
	DEMO_MODULES_PATH + "serialize.cpp",
	NULL
};

class CToolButtonSaveListener : public CButtonListener
{
	virtual void OnClick (CObject *inSender);
};

class CToolButtonDeleteListener : public CButtonListener
{
	virtual void OnClick (CObject *inSender);
};

CDemoModuleSerialize::CDemoModuleSerialize ()
		     :m_Form 		   (NULL),
		      m_TextView	   (NULL),
		      m_StatusBar	   (NULL),
		      m_ToolButtonSave	   (NULL),
		      m_ToolButtonDelete   (NULL)
{
	CDemoModuleSerialize::m_DemoModuleInstance = this;

	CVBoxLayout *VBoxLayout = new CVBoxLayout ();
	VBoxLayout -> SetHomogeneous (false);
	VBoxLayout -> SetBoxPack (BOXPACK_START, false, false, 0);

	CToolBar *ToolBar = new CToolBar (VBoxLayout);
	ToolBar -> SetStyle    (GTK_TOOLBAR_ICONS);
	ToolBar -> SetIconSize (GTK_ICON_SIZE_SMALL_TOOLBAR);

	m_ToolButtonSave = new CToolButton (ToolBar, CString(GTK_STOCK_SAVE), NULL, new CToolButtonSaveListener());
	new CToolSeparatorButton (ToolBar);
	m_ToolButtonDelete = new CToolButton (ToolBar, CString(GTK_STOCK_DELETE), NULL, new CToolButtonDeleteListener());
	m_ToolButtonSave -> SetToolTips (CString("Save the xml dump file"));
	m_ToolButtonDelete -> SetToolTips (CString("Delete the xml dump file"));

	VBoxLayout -> SetBoxPack (BOXPACK_START, true, true, 0);
	CScrollView *ScrollView = new CScrollView (VBoxLayout);

	m_TextView = new CTextView (ScrollView);

	VBoxLayout -> SetBoxPack (BOXPACK_START, false, false, 0);
	m_StatusBar = new CStatusBar (VBoxLayout);
	m_StatusBar -> SetHasResizeGrip (false);

	if (CFile::Exists (DEMO_XML_DUMP + ".sort"))
	{
		CFile File (DEMO_XML_DUMP + ".sort", CString("rb")); 
		*m_TextView << File;
		m_TextView -> ApplyTag (CTextView::m_GtkTextTagMonospace);
		PaintXml ();
	}

	const_cast <TDemoModuleDescription &> (DEMO_MODULE_DESCRIPTION).Layout = VBoxLayout;
}

TDemoModuleDescription CDemoModuleSerialize::GetDescription () const 
{ 
	return DEMO_MODULE_DESCRIPTION; 
}

void CDemoModuleSerialize::Run (CApplication *inOwner) 
{ 
	if (m_Form != NULL) { delete m_Form; m_Form = NULL; }
	if (!CFile::Exists (DEMO_XML_DUMP))
	{
		m_Form = new CForm (inOwner, new CDemoFormSerializeListener());
		m_Form -> SetCaption (CString("Serialized Form"));
		m_Form -> SetBounds (TBounds (TBounds ((CApplication::GetScreenSize().w-420)/2, 
						       (CApplication::GetScreenSize().h-350)/2, 420, 350)));
		CVBoxLayout *VBoxLayout = new CVBoxLayout (m_Form);
		VBoxLayout -> SetHomogeneous (false);
		VBoxLayout -> SetSpacing (1);
		VBoxLayout -> SetBoxPack (BOXPACK_START, false, false, 0);
		CMenuBar  *MenuBar = new CMenuBar  (VBoxLayout);
		CMenuItem *File    = new CMenuItem (MenuBar, CString("_File"));
		CMenuItem *Exit    = new CMenuItem (File, CString("_Quit"), _HKNone_, new CFileExitMenuItemListener());
		VBoxLayout -> SetBoxPack (BOXPACK_START, true, true, 0);
		CTreeView *TreeView = new CTreeView (VBoxLayout, _IFVString_+_IFVPixbuf_);
		CTreeViewItem &Item0 = *new CTreeViewItem (TreeView);
		Item0[0] = CString("Copy");
		Item0[1] = new CPixbuf(GTK_STOCK_COPY);
		Item0.SetDraggable (true);
		Item0.SetDropSite  (true);
		CTreeViewItem &Item1 = *new CTreeViewItem (TreeView);
		Item1[0] = CString("Cut");
		Item1[1] = new CPixbuf(GTK_STOCK_CUT);
		Item1.SetDraggable (true);
		Item1.SetDropSite  (true);
		CTreeViewItem &Item2 = *new CTreeViewItem (TreeView);				
		Item2[0] = CString("Paste");
		Item2[1] = new CPixbuf(GTK_STOCK_PASTE);
		Item2.SetDraggable (true);
		Item2.SetDropSite  (true);
		TreeView -> SetDropSite  (true);
		m_Form -> Show ();
		m_StatusBar -> SetCaption (CString("Xml dump does not exist, explicit demo loaded."));
	}
	else
	{
		CXMLDocument XMLDoc (DEMO_XML_DUMP, XML_READ, CString("gtkol-demo"));
		CXMLElementNode *inXMLRoot = XMLDoc.GetRootElement ();
		CSerialized *inSerialized = CSerialized::Instanciate (inXMLRoot);
		if (inSerialized != NULL)
			if (inSerialized -> ClassIs (__metaclass(CForm))) m_Form = static_cast <CForm *> (inSerialized);
			else delete inSerialized;
		delete inXMLRoot;
		m_StatusBar -> SetCaption (CString("Xml dump exists, demo loaded from scratch."));
	}
}

void CDemoModuleSerialize::Stop () 
{ 
	if (m_Form != NULL) { if (m_Form -> IsShown()) m_Form -> Close(); delete m_Form; m_Form = NULL; }
}

void CDemoModuleSerialize::PaintXml ()
{
	if (m_TextView == NULL) return;

	CString inText (m_TextView -> GetText ());

	size_t i=0, j=0; while (inText.Find (CString("\""), i, &j))
	{
		size_t k=0; if (inText.Find (CString("\""), j+1, &k))
			m_TextView -> ApplyTag (CTextView::m_GtkTextTagFgDarkBlue, (SInt32)j, k+1);
		i = k+1;
	}
	i=0; j=0; while (inText.Find (CString("<"), i, &j) || inText.Find (CString("/"), i, &j))
	{
		size_t k=0; if (inText.Find (CString(" "), j+1, &k) || inText.Find (CString(">"), j+1, &k))
			m_TextView -> ApplyTag (CTextView::m_GtkTextTagFgDarkGreen, (SInt32)j+1, k);
		i = k+1;
	}
}

void CToolButtonSaveListener::OnClick (CObject *)
{
	if (CDemoModuleSerialize::m_DemoModuleInstance -> m_TextView == NULL) return;
	CFile File (DEMO_XML_DUMP, CString("wb"));
	CString inText (CDemoModuleSerialize::m_DemoModuleInstance -> m_TextView -> GetText());
	File.Write (inText.Get(), sizeof(char), inText.GetLength());
	CDemoModuleSerialize::m_DemoModuleInstance -> m_StatusBar -> SetCaption (CString("Xml dump file saved."));
}

void CToolButtonDeleteListener::OnClick (CObject *)
{
	if (CDemoModuleSerialize::m_DemoModuleInstance -> m_TextView == NULL) return;
	if (!CFile::Exists (DEMO_XML_DUMP)) return;
	::system (("rm " + DEMO_XML_DUMP + " " + DEMO_XML_DUMP + ".sort").Get());
	CDemoModuleSerialize::m_DemoModuleInstance -> m_TextView -> SetText (CString());
	CDemoModuleSerialize::m_DemoModuleInstance -> m_StatusBar -> SetCaption (CString("Xml dump file deleted."));
}

DECLARE_METAMODULE_EXPORT (CDemoModuleSerialize);

