/*******************************************************************************************************************************************
 cmainform.h
*******************************************************************************************************************************************/

#ifndef __CMAINFORM_H__
#define __CMAINFORM_H__

#include "capplication.h"
#include "cdemomodule.h"
#include "cmetamoduleimporter.h"

// declare a buffer of meta module importers, each importer owns a specific dynamic demo module
typedef TBuffer <CMetaModuleImporter *> CDemoModuleImporters;

//------------------------------------------------------------------------------------------------------------------------------------------
// main form listener
//------------------------------------------------------------------------------------------------------------------------------------------
class CMainFormListener : public CFormListener
{
	// called when the form is about to be closed
	virtual void OnQueryClose 			(CObject *inSender, Bool &ioDoClose);
};

//------------------------------------------------------------------------------------------------------------------------------------------
// main form / file -> quit menu item listener
//------------------------------------------------------------------------------------------------------------------------------------------
class CMainFormMenuItemQuitListener : public CMenuItemListener
{
	// called when the menu item is clicked
	virtual void OnClick				(CObject *inSender);
};

//------------------------------------------------------------------------------------------------------------------------------------------
// main form tool button execute listener
//------------------------------------------------------------------------------------------------------------------------------------------
class CMainFormToolButtonExecListener : public CButtonListener
{
	// called when the toolbutton is clicked
	virtual void OnClick				(CObject *inSender);
};

//------------------------------------------------------------------------------------------------------------------------------------------
// main form tool button stop listener
//------------------------------------------------------------------------------------------------------------------------------------------
class CMainFormToolButtonStopListener : public CButtonListener
{
	// called when the toolbutton is clicked
	virtual void OnClick				(CObject *inSender);
};

//------------------------------------------------------------------------------------------------------------------------------------------
// demo tree view listener
//------------------------------------------------------------------------------------------------------------------------------------------
class CMainFormDemoTreeViewListener : public CTreeViewListener
{
	// called when the specified treeview item has been activated
	virtual void OnItemActivated 			(CObject *inSender, CObject *inItem);

	// called when the specified treeview item is about to be selected / unselected
	virtual void OnItemQuerySelect			(CObject *inSender, CObject *inItem, const Bool inCurrent, Bool &ioDoToggle);
};

//------------------------------------------------------------------------------------------------------------------------------------------
// owverload the treeview item definition, each of the treeview items will be associated to a demo module
//------------------------------------------------------------------------------------------------------------------------------------------
class CMainFormDemoModuleTreeViewItem : public CTreeViewItem
{
	// instanciation section
	public :

		CMainFormDemoModuleTreeViewItem		(CTreeView     *inOwner, const CDemoModule *inDemoModule);
		CMainFormDemoModuleTreeViewItem		(CTreeViewItem *inOwner, const CDemoModule *inDemoModule);

	// specific attributes
	public :

		// the tree view item associated demo module
		CDemoModule *				m_DemoModule;
};

//------------------------------------------------------------------------------------------------------------------------------------------
// main form declaration
//------------------------------------------------------------------------------------------------------------------------------------------
class CMainForm : public CForm
{
	// instanciation section
	public :

		CMainForm				(CApplication *);
		virtual ~CMainForm			();

	// public services
	public :

		// do a syntax color operation on the m_TextViewCode attribute
		void					PaintTextViewCode	();

	// demo main form gui attributes section
	public :

		CVBoxLayout *				m_VBoxLayout;

		CMenuBar *				m_MenuBar;
		CMenuItem *				m_MenuItemFile;
		CMenuItemImage *			m_MenuItemQuit;

		CToolBar *				m_ToolBar;
		CToolButton *				m_ToolButtonExec;
		CToolButton *				m_ToolButtonStop;

		CHPaned *				m_HPaned;

		CScrollView *				m_ScrollViewL;
		CTreeView *				m_TreeView;

		CNoteBook *				m_NoteBook;
		CScrollView *				m_ScrollViewR;
		CTextView *				m_TextViewDesc;
		CTextView *				m_TextViewCode;

		CVBoxLayout *				m_VBoxExtra;
		CLabel *				m_UnusedLabel;

	// public attributes
	public :

		// our demo modules importers
		CDemoModuleImporters			m_DemoModuleImporters;

	// protected section
	protected :

		// check if the specified string is isolated i.e. if it is a potential key word that should be colorated 
		inline bool				IsIsolated		(const CString &, const size_t, const size_t);
};

#endif
