// $Id: AbstractDemoPanel.java,v 1.7 2006/02/26 00:59:07 pietschy Exp $
// Copyright (c) 2000-2001 The Forge Group. All rights reserved.
/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: AbstractDemoPanel.java,v 1.7 2006/02/26 00:59:07 pietschy Exp $
 */
package org.pietschy.command.demo;

import au.com.skypie.ui.BorderUtil;
import au.com.skypie.ui.HTMLPane;
import org.pietschy.command.CommandGroup;
import org.pietschy.command.CommandHyperlinkListener;

import javax.swing.*;
import java.awt.*;

public abstract class
AbstractDemoPanel
extends DemoPanel
{
   static final String _ID_ = "$Id: AbstractDemoPanel.java,v 1.7 2006/02/26 00:59:07 pietschy Exp $";

   public AbstractDemoPanel(String name, String selectorId, String commandsUrl)
   {
      super(name, selectorId, commandsUrl);

      HTMLPane html = new HTMLPane();
      html.setAntiAlias(false);
      html.addHyperlinkListener(new CommandHyperlinkListener());
      loadBlurb(html);
      JSplitPane sp = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, new JScrollPane(html), createExamplePanel());
      setBorder(BorderUtil.standardPadding());
      setLayout(new BorderLayout());
      add(sp, BorderLayout.CENTER);

      sp.setDividerLocation(getDividerLocation());
   }

   public abstract void
   loadBlurb(HTMLPane html);

   public abstract JComponent
   createExamplePanel();

   public int
   getDividerLocation()
   {
      return 280;
   }

   public CommandGroup
   getToolbarGroup()
   {
      return null;
   }

   protected JComponent createTextArea(String text)
   {
      JTextArea textArea;
      textArea = new JTextArea(text);
      textArea.setColumns(25);
//      textArea.setRows(3);
      textArea.setLineWrap(true);
      textArea.setWrapStyleWord(true);
      textArea.setBorder(BorderUtil.standardPadding(BorderFactory.createLineBorder(Color.LIGHT_GRAY)));
      textArea.setBackground(new Color(255,255,240));
      textArea.setEditable(false);
      textArea.setFocusable(false);
      return textArea;
//      return new JScrollPane(textArea);
   }
}
