/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: GroupDemoPanel.java,v 1.10 2006/02/26 00:59:08 pietschy Exp $
 */

package org.pietschy.command.demo.group;


import au.com.skypie.ui.HTMLPane;
import org.pietschy.command.CommandGroup;
import org.pietschy.command.CommandManager;
import org.pietschy.command.demo.AbstractDemoPanel;
import org.pietschy.explicit.TableBuilder;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;

public class
GroupDemoPanel
extends AbstractDemoPanel
{
   static final String _ID_ = "$Id: GroupDemoPanel.java,v 1.10 2006/02/26 00:59:08 pietschy Exp $";

   private CommandGroup[] menus;

   public GroupDemoPanel()
   {
      super("Group Examples", "group-page.selector", "group-commands.xml");

   }

   public void
   loadBlurb(HTMLPane html)
   {
      try
      {
         html.setPage(getClass().getResource("group.html"));
      }
      catch (IOException e)
      {
         throw new RuntimeException("Couldn't load toggle file", e);
      }
   }

   public JComponent
   createExamplePanel()
   {
      CommandManager cm = CommandManager.defaultInstance();
      menus = new CommandGroup[] {cm.getGroup("group-page.menu")};

      TableBuilder builder = new TableBuilder();

      int row = 0;
      CommandGroup gc = cm.getGroup("group-page.group-one");
      builder.addXY(createTextArea("Groups one and two are both basic groups that each contain two commands."), 0, row, 1, 2)
      .fill()
      .minimumWidth(0);
      builder.addXY(gc.createButton(), 1, row).fillX();

      row++;
      gc = cm.getGroup("group-page.group-two");
//      builder.addXY(createTextArea("This is another basic group that contains two commands."), 0, row)
//      .fill()
//      .minimumWidth(0);
      builder.addXY(gc.createButton(), 1, row).fillX();
      builder.row(row).paddingBottom(builder.layoutStyle().unrelatedRowGap());

      row++;
      gc = cm.getGroup("group-page.group-three");
      builder.addXY(createTextArea("Group three contains the first two groups."), 0, row)
      .fill()
      .minimumWidth(0);
      builder.addXY(gc.createButton(), 1, row).fillX();
      builder.row(row).paddingBottom(builder.layoutStyle().unrelatedRowGap());

      row++;
      gc = cm.getGroup("group-page.group-four");
      builder.addXY(createTextArea("Group four contains the first two groups, once normally and once 'inline'."), 0, row)
      .fill()
      .minimumWidth(0);
      builder.addXY(gc.createButton(), 1, row).fillX();

      row++;
      gc = cm.getGroup("group-page.menu");
      JComponent textArea = createTextArea("Right click here to see the group menu as a popup menu");
      new PopupAdapter(textArea, gc.createPopupMenu());
      builder.addXY(textArea, 0, row)
      .fill()
      .minimumWidth(0);


      builder.firstColumn().grow(1);
      builder.firstColumn().paddingLeft(0);
      builder.firstRow().paddingTop(0);
      builder.margin(builder.layoutStyle().tabbedDialogMargin());
      builder.buildLayout();

      JPanel panel = builder.getPanel();
      panel.setBackground(Color.WHITE);
      return new JScrollPane(panel);
   }

   public CommandGroup[]
   getMenuGroups()
   {
      return menus;
   }

   public CommandGroup
   getToolbarGroup()
   {
      return menus[0];
   }

   private class
   PopupAdapter
   extends MouseAdapter
   {
      private JPopupMenu menu;
      private JComponent invoker;

      public PopupAdapter(JComponent invoker, JPopupMenu menu)
      {
         this.invoker = invoker;
         this.menu = menu;

         invoker.addMouseListener(this);
      }

      public void mousePressed(MouseEvent e)
      {
         if (e.isPopupTrigger())
            showPopup(e.getPoint());
      }

      public void mouseReleased(MouseEvent e)
      {
         if (e.isPopupTrigger())
            showPopup(e.getPoint());
      }

      private void showPopup(Point p)
      {
         menu.show(invoker,  p.x, p.y);
      }

   }
}
