import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import cz.autel.dmi.*;
import javax.swing.border.*;

/*
 * Demo for using HIGLayout.
 * @author daniel.michalik@autel.cz
 */
public class Demo1Dialog extends JDialog {
	public Demo1Dialog(boolean corrections) {
		setTitle(corrections ? "Dialog with corrections" : "Dialog without corrections");
		JPanel p1 = new JPanel();
		int w1[] = {12,0,11,0,11};
		int h1[] = {0,8,0};
		HIGLayout l1 = new HIGLayout(w1, h1);
		p1.setLayout(l1);
		HIGConstraints c = new HIGConstraints();
		if(corrections) c.setVCorrection(0,-3);
		p1.add(new JLabel("Font:"), c.xy(2,1));
		String fonts[] = { "Helvetica" };
		p1.add(new JComboBox(fonts), c.xy(4,1));
		String sizes[] = { "18" };
		JComboBox sizesCombo = new JComboBox(sizes);
		sizesCombo.setEditable(true);

		p1.add(new JLabel("Size:"), c.xy(2,3));
		if(corrections) c.setVCorrection(0,-7);
		p1.add(sizesCombo, c.xy(4,3,"l").W(50));		

		if(corrections) c.clearCorrection();
		JPanel p2 = new JPanel();
		int w2[] = {12,0,17,0,11};
		int h2[] = {20,0,0,0};
		HIGLayout l2 = new HIGLayout(w2, h2);
		p2.setLayout(l2);
		if(corrections) c.setVCorrection(-3,-7);
		p2.add( new JCheckBox("Bold"), c.xy(2,2));
		p2.add( new JCheckBox("Italic"), c.nextRow());
		p2.add( new JCheckBox("Underline"), c.nextRow());
		JRadioButton r21 = new JRadioButton("Normal");
		JRadioButton r22 = new JRadioButton("Superscript");
		JRadioButton r23 = new JRadioButton("Subscript");
		ButtonGroup g2 = new ButtonGroup();
		g2.add(r21); g2.add(r22); g2.add(r23);
		p2.add( r21, c.xy(4,2));
		p2.add( r22, c.nextRow());
		p2.add( r23, c.nextRow());

		if(corrections) c.clearCorrection();
		JPanel p3 = new JPanel();
		int w3[] = {12,0,-7,5,-3,5,-5,11};
		int h3[] = {23,0};
		HIGLayout l3 = new HIGLayout(w3, h3);
		l3.setColumnWeight(2,1);
		p3.setLayout(l3);
		if(corrections) c.setVCorrection(0,-4);
		JButton b31 = new JButton("Apply");
		JButton b32 = new JButton("Reset");
		JButton b33 = new JButton("Close");
		p3.add(b31, c.xy(3,2));
		p3.add(b32, c.xy(5,2));
		p3.add(b33, c.xy(7,2));		
		
		if(corrections) c.clearCorrection();
		JPanel p = new JPanel();
		int w[] = {0};
		int h[] = {12,0,0,0,11};
		HIGLayout l = new HIGLayout(w, h);
		l.setColumnWeight(1,1);
		l.setRowWeight(4,1);		
		p.setLayout(l);
		p.add(p1, c.xy(1,2));
		p.add(p2, c.xy(1,3));
		p.add(p3, c.xy(1,4,"lrb"));
		getContentPane().add(p, BorderLayout.CENTER);		
	}
}

