/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#ifndef ISDLOGGER_H
#define ISDLOGGER_H

/**
 * General application-level Singleton with extendable log functionality 
 *
 * @author Bram Biesbrouck <b@beligum.org>
*/

#include <string>
#include <iostream>

#include <libinstrudeo/isdobject.h>

using namespace std;

class ISDLogger : public ISDObject
{

public:
    enum logLevel {
	ISD_LOG_LEVEL_INFO,
	ISD_LOG_LEVEL_WARNING,
	ISD_LOG_LEVEL_CRITICAL
    };

    enum logType {
	ISD_LOG_TYPE_FANCY,
	ISD_LOG_TYPE_SYSLOG
    };

    static ISDLogger* getInstance();

    /**
     * Logs the message (default is standard out) if the current log level permits it
     * Note: the err flag chooses between clog (!!) and cerr
     */
    void log(logLevel level, string headerTitle, string message,
	     ostream& stream = cout, logType type = ISD_LOG_TYPE_FANCY, string host = "", string program = "");

    /**
     * Sets the threshold log level.
     *
     * @param level The new log level.
     */
    void setLevel(logLevel level);

    /**
     * Returns the current log level threshold.
     *
     * @return The current log level.
     */
    logLevel getLevel();

 protected:
    ISDLogger();

    bool loggingEnabled;
    logLevel currentLevel;
    static ISDLogger* instance;

};

#endif
