#ifndef _SIGNALTHREAD_H_
#define _SIGNALTHREAD_H_

#include "talk/base/thread.h"
#include "talk/base/sigslot.h"

namespace cricket {
	
class SignalThread : public MessageHandler {
public:
  SignalThread();

  // Call to start the worker thread.  Override to do pre-work cleanup.
  virtual void StartWork();

  // Call from the main thread.  Ask the worker to halt.  OnWorkDone is never called.
  virtual void StopWork();

  // Call from the main thread.  Implicitly calls StopWork
  void Destroy();

  // Call from the main thread. Lets the worker thread finish and deletes the object after
  // emitting SignalWorkDone
  void DestroyWhenDone() { destroy_when_done_ = true; }

  // Signalled from the main thread in OnWorkDone
  sigslot::signal1<SignalThread *> SignalWorkDone;

protected:
  virtual ~SignalThread();

  // Called from the worker thread.  Override to do work.
  // Note: Do not use "this" if SignalThread may be destroyed. "halt" is safe.
  virtual void DoWork(bool * halt) = 0;

  // Call from the worker thread.  Returns false if the thread should terminate.
  // Note: Do not call if SignalThread may be destroyed.  Use "halt" instead.
  bool ContinueWorking();

  // Called in the main thread. Override to do post-work cleanup.
  virtual void OnWorkDone();
  
  virtual void OnMessage(Message *msg);

private:
  class WorkerThread;
  friend class WorkerThread;
  WorkerThread * worker_;
  bool destroy_;
  bool destroy_when_done_;
};

}

#endif // _SIGNALTHREAD_H_
