//start of PreLh3Decoder.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * PreLh3Decoder.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.InputStream;
import java.lang.Math;
import jp.gr.java_conf.dangan.io.BitInputStream;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;

//import exceptions
import java.io.IOException;
import java.io.EOFException;
import java.lang.NullPointerException;
import java.lang.IllegalArgumentException;
import jp.gr.java_conf.dangan.io.BitDataBrokenException;
import jp.gr.java_conf.dangan.io.NotEnoughBitsException;
import jp.gr.java_conf.dangan.util.lha.BadHuffmanTableException;

/**
 * -lh3- 𓀗p PreLzssDecoderB
 * 
 * <pre>
 * -- revision history --
 * $Log: PreLh3Decoder.java,v $
 * Revision 1.1  2002/12/01 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [bug fix]
 *     available ̌vZÂ̂CB
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class PreLh3Decoder implements PreLzssDecoder {


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private static final int DictionarySize
    //  private static final int MaxMatch
    //  private static final int Threshold
    //------------------------------------------------------------------
    /** TCY */
    private static final int DictionarySize = 8192;

    /** őv */
    private static final int MaxMatch       = 256;

    /** ŏv */
    private static final int Threshold      = 3;


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  private static final int CodeSize
    //------------------------------------------------------------------
    /**
     * codẽnt}؂̃TCY 
     * codeȏ̒lꍇ͗]vȃrbgo͂ĕ₤B
     */
    private static final int CodeSize = 286;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  source
    //------------------------------------------------------------------
    //  private BitInputStream in
    //------------------------------------------------------------------
    /**
     * -lh3- ̈kf[^ BitInputStream
     */
     private BitInputStream in;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  huffman decoder
    //------------------------------------------------------------------
    //  private int blockSize
    //  private int[] codeLen
    //  private short[] codeTable
    //  private int codeTableBits
    //  private short[][] codeTree
    //  private int[] offHiLen
    //  private short[] offHiTable
    //  private int offHiTableBits
    //  private short[][] offHiTree
    //------------------------------------------------------------------
    /**
     * ݏ̃ubN̎cTCYB
     */
    private int blockSize;

    /**
     * code ̃nt}̕\
     */
    private int[] codeLen;

    /**
     * code p̃e[u
     * ̏ꍇ codeTree indexB
     * ̏ꍇ code Srbg]́B 
     */
    private short[] codeTable;

    /**
     * codeTable ߂ɕKvbitB
     */
    private int codeTableBits;

    /**
     * codeTable Ɏ܂肫Ȃf[^̕p̖
     * ̏ꍇ codeTree indexB
     * ̏ꍇ code Srbg]́B 
     */
    private short[][] codeTree;

    /**
     * offHi ̃nt}̕\
     */
    private int[] offHiLen;

    /**
     * offHi p̃e[u
     * ̏ꍇ offHi indexB
     * ̏ꍇ code Srbg]́B 
     */
    private short[] offHiTable;

    /**
     * offHiTable ߂ɕKvbitB
     */
    private int offHiTableBits;

    /**
     * offHiTable Ɏ܂肫Ȃf[^̕p̖
     * ̏ꍇ offHi indexB
     * ̏ꍇ code Srbg]́B 
     */
    private short[][] offHiTree;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  backup for mark/reset
    //------------------------------------------------------------------
    //  private int markBlockSize
    //  private int[] markCodeLen
    //  private short[] markCodeTable
    //  private short[][] markCodeTree
    //  private int[] markOffHiLen
    //  private short[] markOffHiTable
    //  private short[][] markOffHiTree
    //------------------------------------------------------------------
    /** blockSizẽobNAbvp */
    private int markBlockSize;
    /** codeLen ̃obNAbvp */
    private int[] markCodeLen;
    /** codeTable ̃obNAbvp */
    private short[] markCodeTable;
    /** codeTree ̃obNAbvp */
    private short[][] markCodeTree;
    /** offHiLen ̃obNAbvp */
    private int[] markOffHiLen;
    /** offHiTable ̃obNAbvp */
    private short[] markOffHiTable;
    /** offHiTree ̃obNAbvp */
    private short[][] markOffHiTree;


    //------------------------------------------------------------------
    //  constructer
    //------------------------------------------------------------------
    //  private PreLh3Decoder()
    //  public PreLh3Decoder( InputStream in )
    //  public PreLh3Decoder( InputStream in, 
    //                        int CodeTableBits, int OffHiTableBits )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private PreLh3Decoder(){    }

    /**
     * -lh3- 𓀗p PreLzssDecoder \zB<br>
     * e[uTCYɂ ftHglgpB
     * 
     * @param in kf[^̓Xg[
     */
    public PreLh3Decoder( InputStream in ){
        this( in, 12, 8 );
    }

    /**
     * -lh3- 𓀗p PreLzssDecoder \zB<br>
     * 
     * @param in             kf[^̓Xg[
     * @param CodeTableBits  code 𕜍邽߂Ɏgp
     *                       e[ũTCYrbgŎw肷B 
     *                       12 w肷 4096 ̃bNAbve[u𐶐B 
     * @param OffHiTableBits offHi 𕜍邽߂Ɏgp
     *                       e[ũTCYrbgŎw肷B
     *                       8 w肷 256 ̃bNAbve[u𐶐B 
     * 
     * @exception IllegalArgumentException
     *                       CodeTableBits, OffHiTableBits  0ȉ̏ꍇ
     */
    public PreLh3Decoder( InputStream in, 
                          int         CodeTableBits,
                          int         OffHiTableBits ){
        if( in != null
         && 0 < CodeTableBits
         && 0 < OffHiTableBits ){
            if( in instanceof BitInputStream ){
                this.in = (BitInputStream)in;
            }else{
                this.in = new BitInputStream( in );
            }
            this.blockSize      = 0;
            this.codeTableBits  = CodeTableBits;
            this.offHiTableBits = OffHiTableBits;
        }else if( in == null ){
            throw new NullPointerException( "in" );
        }else if( CodeTableBits <= 0 ){
            throw new IllegalArgumentException( "CodeTableBits too small. CodeTableBits must be larger than 1." );
        }else{
            throw new IllegalArgumentException( "OffHiTableBits too small. OffHiTableBits must be larger than 1." );
        }
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  read
    //------------------------------------------------------------------
    //  public int readCode()
    //  public int readOffset()
    //------------------------------------------------------------------
    /**
     * -lh3- ňkꂽ
     * 1byte LZSSk̃f[^A
     * ͈kR[ĥvǂݍށB<br>
     * 
     * @return 1byte  k̃f[^́A
     *         kꂽkR[ĥv
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException EndOfStreamɒBꍇ
     * @exception BadHuffmanTableException
     *                         nt}؂\邽߂
     *                         nt}̕\sȂ߁A
     *                         nt}킪łȂꍇ
     */
    public int readCode() throws IOException {
        if( this.blockSize <= 0 ){
            this.readBlockHead();
        }
        this.blockSize--;

        int code;
        try{
            int node = this.codeTable[ this.in.peekBits( this.codeTableBits ) ];
            if( node < 0 ){
                code = ~node;
                this.in.skipBits( this.codeLen[ code ] );
            }else{
                this.in.skipBits( this.codeTableBits );
                do{
                    node = this.codeTree[ this.in.readBit() ][ node ];
                }while( 0 <= node );
                code = ~node;
            }
        }catch( NotEnoughBitsException exception ){
            int avail = exception.getAvailableBits();
            int bits = this.in.peekBits( avail );
            bits = bits << ( this.codeTableBits - avail );
            int node = this.codeTable[ bits ];

            if( node < 0 ){
                code = ~node; 
                if( this.in.skipBits( this.codeLen[code] ) < this.codeLen[code] ){
                    throw new EOFException();
                }
            }else{
                this.in.skipBits( avail );
                throw new EOFException();
            }
        }catch( ArrayIndexOutOfBoundsException exception ){
            throw new EOFException();
        }

        final int CodeMax = PreLh3Decoder.CodeSize - 1;
        if( code == CodeMax ){
            code += this.in.readBits( 8 );
        }
        return code;
    }

    /**
     * -lh3- ňkꂽ
     * LZSSkR[ĥvʒuǂݍށB<br>
     * 
     * @return -lh3- ňkꂽkR[ĥvʒu
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int readOffset() throws IOException {
        int offHi;
        try{
            int node = this.offHiTable[ this.in.peekBits( this.offHiTableBits ) ];
            if( node < 0 ){
                offHi = ~node;
                this.in.skipBits( this.offHiLen[ offHi ] );
            }else{
                this.in.skipBits( this.offHiTableBits );
                do{
                    node = this.offHiTree[ this.in.readBit() ][ node ];
                }while( 0 <= node );
                offHi = ~node;
            }
        }catch( NotEnoughBitsException exception ){
            int avail = exception.getAvailableBits();
            int bits = this.in.peekBits( avail );
            bits = bits << ( this.offHiTableBits - avail );
            int node = this.offHiTable[ bits ];

            if( node < 0 ){
                offHi = ~node; 
                if( this.offHiLen[offHi] <= avail ){
                    this.in.skipBits( this.offHiLen[offHi] );
                }else{
                    this.in.skipBits( avail );
                    throw new EOFException();
                }
            }else{
                this.in.skipBits( avail );
                throw new EOFException();
            }
        }catch( ArrayIndexOutOfBoundsException exception ){
            throw new EOFException();
        }
        
        return ( offHi << 6 ) | this.in.readBits( 6 );
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  mark / reset
    //------------------------------------------------------------------
    //  public void mark( int readLimit )
    //  public void reset()
    //  public boolean markSupported()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[݈̌ʒuɃ}[Nݒ肵A
     * reset() \bhŃ}[N_ ǂݍ݈ʒu
     * ߂悤ɂB<br>
     * InputStream  mark() ƈႢAreadLimit Őݒ肵
     * EoCgOɃ}[NʒuɂȂ\
     * 鎖ɒӂ邱ƁB<br>
     * 
     * @param readLimit }[Nʒuɖ߂ẼoCgB
     *                  ̃oCg𒴂ăf[^ǂ
     *                  񂾏ꍇ reset()łȂȂ
     *                  \B<br>
     * 
     * @see PreLzssDecoder#mark(int)
     */
    public void mark( int readLimit ){
        readLimit = readLimit * StaticHuffman.LimitLen / 8;
        if( this.blockSize < readLimit ){
            readLimit += 245;
        }
        this.in.mark( readLimit );

        this.markBlockSize  = this.blockSize;
        this.markCodeLen    = this.codeLen;
        this.markCodeTable  = this.codeTable;
        this.markCodeTree   = this.codeTree;
        this.markOffHiLen   = this.offHiLen;
        this.markOffHiTable = this.offHiTable;
        this.markOffHiTree  = this.offHiTree;
    }

    /**
     * ڑꂽ̓Xg[̓ǂݍ݈ʒuŌ
     * mark() \bhĂяoꂽƂ̈ʒuɐݒ肷B<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void reset() throws IOException {
        //mark()Ȃ reset() 悤ƂꍇA
        //readLimit 𒴂 reset() 悤ƂꍇA
        //ڑꂽ InputStream  markSupported()  false Ԃꍇ
        //BitInputStream  IOException 𓊂B
        this.in.reset();                                                        //throws IOException

        this.blockSize  = this.markBlockSize;
        this.codeLen    = this.markCodeLen;
        this.codeTable  = this.markCodeTable;
        this.codeTree   = this.markCodeTree;
        this.offHiLen   = this.markOffHiLen;
        this.offHiTable = this.markOffHiTable;
        this.offHiTree  = this.markOffHiTree;
    }

    /**
     * ڑꂽ̓Xg[ mark()  reset() 
     * T|[g邩𓾂B<br>
     * 
     * @return Xg[ mark()  reset() 
     *         T|[gꍇ trueB<br>
     *         T|[gȂꍇ falseB<br>
     */
    public boolean markSupported(){
        return this.in.markSupported();
    }

    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public int available()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ubNɓǂݏoƂ̏oŒoCg𓾂B<br>
     * InputStream  available() ƈႢA
     * ̍ŒoCg͕KۏႳĂȂɒӂ邱ƁB<br>
     * 
     * @return ubNȂœǂݏoŒoCgB<br>
     * 
     * @exception IOException o̓G[ꍇ
     * 
     * @see PreLzssDecoder#available()
     */
    public int available() throws IOException {
        int avail = this.in.available() * 8 / StaticHuffman.LimitLen;
        if( this.blockSize < avail ){
            avail -= 245;
        }
        return Math.max( avail, 0 );
    }

    /**
     * ̃Xg[AgpĂSĂ̎B
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.in.close();
        this.in             = null;

        this.blockSize      = 0;
        this.codeLen        = null;
        this.codeTable      = null;
        this.codeTree       = null;
        this.offHiLen       = null;
        this.offHiTable     = null;
        this.offHiTree      = null;

        this.markBlockSize  = 0;
        this.markCodeLen    = null;
        this.markCodeTable  = null;
        this.markCodeTree   = null;
        this.markOffHiLen   = null;
        this.markOffHiTable = null;
        this.markOffHiTree  = null;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  get LZSS parameter
    //------------------------------------------------------------------
    //  public int getDictionarySize()
    //  public int getMaxMatch()
    //  public int getThreshold()
    //------------------------------------------------------------------
    /**
     * -lh3-` LZSS̃TCY𓾂B
     * 
     * @return -lh3-` LZSS̃TCY
     */
    public int getDictionarySize(){
        return PreLh3Decoder.DictionarySize;
    }

    /**
     * -lh3-` LZSS̍őv𓾂B
     * 
     * @return -lh3-` LZSS̍őv
     */
    public int getMaxMatch(){
        return PreLh3Decoder.MaxMatch;
    }

    /**
     * -lh3-` LZSS̈kA񈳏k臒l𓾂B
     * 
     * @return -lh3-` LZSS̈kA񈳏k臒l
     */
    public int getThreshold(){
        return PreLh3Decoder.Threshold;
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  read block head
    //------------------------------------------------------------------
    //  private void readBlockHead()
    //  private int[] readCodeLen()
    //  private int[] readOffHiLen()
    //------------------------------------------------------------------
    /**
     * nt}ubN̐擪ɂ
     * ubNTCYnt}̃XgǂݍށB
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException EndOfStreamɒBꍇ
     * @exception BadHuffmanTableException
     *                         nt}؂\邽߂
     *                         nt}̕\sȂ߁A
     *                         nt}킪łȂꍇ
     * @exception BitDataBrokenException
     *                         \ʌŃf[^ǂ݂݂
     *                         fꂽߗvꂽrbg
     *                         ̃f[^Ȃꍇ
     */
    private void readBlockHead() throws IOException {
        //ubNTCYǂݍ
        //ȃf[^̏ꍇA̕ EndOfStream ɓBB
        try{
            this.blockSize = this.in.readBits( 16 );                            //throws BitDataBrokenException, EOFException, IOException
        }catch( BitDataBrokenException exception ){
            if( exception.getCause() instanceof EOFException ){
                throw (EOFException)exception.getCause();
            }else{
                throw exception;
            }
        }

        //code ̏
        this.codeLen = this.readCodeLen();
        if( 1 < this.codeLen.length ){
            short[][] tableAndTree = 
                StaticHuffman.createTableAndTree( this.codeLen, this.codeTableBits );
            this.codeTable = tableAndTree[0];
            this.codeTree  = new short[][]{ tableAndTree[1], tableAndTree[2] };
        }else{
            int code = this.codeLen[0];
            this.codeLen   = new int[ PreLh3Decoder.CodeSize ];
            this.codeTable = new short[ 1 << this.codeTableBits ];
            for( int i = 0 ; i < this.codeTable.length ; i++ ){
                this.codeTable[i] = ((short)~code);
            }
            this.codeTree = new short[][]{ new short[0], new short[0] };
        }

        //offHi ̏
        this.offHiLen = this.readOffHiLen();
        if( 1 < this.offHiLen.length ){
            short[][] tableAndTree = 
                StaticHuffman.createTableAndTree( this.offHiLen, this.offHiTableBits );
            this.offHiTable = tableAndTree[0];
            this.offHiTree  = new short[][]{ tableAndTree[1], tableAndTree[2] };
        }else{
            int offHi = this.offHiLen[0];
            this.offHiLen   = new int[ PreLh3Decoder.DictionarySize >> 6 ];
            this.offHiTable = new short[ 1 << this.offHiTableBits ];
            for( int i = 0 ; i < this.offHiTable.length ; i++ ){
                this.offHiTable[i] = ((short)~offHi);
            }
            this.offHiTree = new short[][]{ new short[0], new short[0] };
        }
    }

    /**
     * code ̃nt}̃Xgǂ݂ށB
     * 
     * @return nt}̃XgB
     *           1 ̗B̃R[h
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException EndOfStreamɒBꍇ
     * @exception BitDataBrokenException
     *                         \ʌŃf[^ǂ݂݂
     *                         fꂽߗvꂽrbg
     *                         ̃f[^Ȃꍇ
     */
    private int[] readCodeLen() throws IOException {
        int[] codeLen = new int[ PreLh3Decoder.CodeSize ];

        for( int i = 0 ; i < codeLen.length ; i++ ){
            if( this.in.readBoolean() )
                codeLen[i] = this.in.readBits( 4 ) + 1;

            if( i == 2 && codeLen[0] == 1 && codeLen[1] == 1 && codeLen[2] == 1 ){
                return new int[]{ this.in.readBits( 9 ) };
            }
        }
        return codeLen;
    }

    /**
     * offHĩnt}̃Xgǂ݂
     * 
     * @return nt}̃XgB
     *           1 ̗B̃R[h
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException EndOfStreamɒBꍇ
     * @exception BitDataBrokenException
     *                         \ʌŃf[^ǂ݂݂
     *                         fꂽߗvꂽrbg
     *                         ̃f[^Ȃꍇ
     */
    private int[] readOffHiLen() throws IOException {
        if( this.in.readBoolean() ){
            int[] offHiLen = new int[ PreLh3Decoder.DictionarySize >> 6 ];

            for( int i = 0 ; i < offHiLen.length ; i++ ){
                offHiLen[i] = this.in.readBits( 4 );

                if( i == 2 && offHiLen[0] == 1 && offHiLen[1] == 1 && offHiLen[2] == 1 ){
                    return new int[]{ this.in.readBits( 7 ) };
                }
            }
            return offHiLen;
        }else{
            return PreLh3Decoder.createConstOffHiLen();
        }
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  constant huffman tree
    //------------------------------------------------------------------
    //  private static int[] createConstOffHiLen()
    //------------------------------------------------------------------
    /**
     * -lh3-  offsetfR[hpStaticHuffman
     * nt}Xg𐶐B
     * 
     * @return -lh3-  offsetfR[hpStaticHuffman
     *         nt}Xg
     */
    private static int[] createConstOffHiLen(){
        final int length = PreLh3Decoder.DictionarySize >> 6;
        final int[] list = { 2, 0x01, 0x01, 0x03, 0x06, 0x0D, 0x1F, 0x4E, 0 };

        int[] LenList = new int[ length ];
        int index = 0;
        int len = list[ index++ ];

        for( int i = 0 ; i < length ; i++ ){
            while( list[index] == i ){
                len++;
                index++;
            }
            LenList[i] = len;
        }
        return LenList;
    }

}
//end of PreLh3Decoder.java
