/*  $Id: lingdefs.h,v 1.20 2005/03/27 21:55:39 marcusva Exp $
 *  
 *  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2004 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.  
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details.  
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#ifndef LINGDEFS_H
#define LINGDEFS_H 1

#ifdef __cplusplus
#  define BEGIN_C_DECLS extern "C" {
#  define END_C_DECLS   }
#else
#  define BEGIN_C_DECLS
#  define END_C_DECLS
#endif

#ifndef FALSE
#define FALSE (0)
#endif

#ifndef TRUE
#define TRUE (!FALSE)
#endif

/**
 * \def LING_ARRAY_LEN(array)
 *
 * A macro to get the size of an array (the element amount).
 */
#define LING_ARRAY_LEN(array) (sizeof(array) / sizeof((array)[0]))

BEGIN_C_DECLS

/**
 * \typedef lingbool
 *
 * This is a special defined boolean value, which can return TRUE and FALSE
 * (and should only be used with those both types!).
 */ 
typedef int lingbool;

/**
 * \typedef lingchar
 *
 * This is an unsigned char to hold UTF-8 encoded characters.
 */
typedef unsigned char lingchar;

/* \typedef luint
 *
 * Abbreviation for unsigned integers.
 */
typedef unsigned int luint;

/**
 * \struct lingConfig
 *
 * A structure for configuration settings 
 */
typedef struct 
{
     void     *pdata;    /**< Private data structure, which should not be
                            modified */

     lingchar *appname;  /**< The name of the application */
     char     *langfile; /**< The file with the languages */
} lingConfig;

/**
 * \struct lingLesson
 *
 * A public lesson list structure
 */
typedef struct _lingLesson lingLesson;
struct _lingLesson
{
     void       *pdata;  /**< Private data, which should not be modified! */

     lingConfig *config; /**< The configuration used for loading */
     lingchar   *type;   /**< The type of the lesson */
     lingchar   *sound;  /**< The sound subdirectory of the lesson */
     lingLesson *next;   /**< Pointer to the next lesson */
};

/**
 * \struct lingMInfo
 *
 */
typedef struct
{
     lingchar  *description; /**< The description of the meaning */
     lingchar  *phonetic;    /**< The phonetic notation of the translation */
     lingchar **images;      /**< The images for that meaning */
} lingMInfo;

/**
 * \struct lingMeaning
 *
 * The structure of a meaning
 */
typedef struct _lingMeaning lingMeaning;
struct _lingMeaning
{
     luint         id;          /**< ID of the Meaning (123) */
     lingchar     *type;        /**< Type of the meaning */
     lingchar     *language;    /**< Translation language */
     lingchar     *translation; /**< The translation text */
     lingLesson   *lesson;      /**< Lesson the translation was taken from */
     lingMInfo    *info;        /**< Pointer to additional information */ 
     lingMeaning  *next;        /**< The next meaning in the list */
     lingMeaning  *prev;        /**< The previous meaning in the list */
};

END_C_DECLS

#endif /* LINGDEFS_H */
