/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.editor.hints.options;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import org.netbeans.spi.editor.hints.ProvidersList;
import org.netbeans.spi.editor.hints.Severity;

/**
 *
 * @author Jan Lahoda
 */
public class ModelImpl {

    private AdvancedHintsPanel panel;

    private Map<String, Boolean> key2Enabled;
    private Map<String, Map<String, Severity>> key2Error2Severity;

    private int eagerness;

    /** Creates a new instance of ModelImpl */
    public ModelImpl(AdvancedHintsPanel panel) {
	this.panel = panel;
	key2Enabled = new HashMap<String, Boolean>();
	key2Error2Severity = new HashMap<String, Map<String, Severity>>();
        eagerness = (-1);
    }
    
    public synchronized boolean isProviderEnabled(String providerKey) {
	Boolean cache = (Boolean) key2Enabled.get(providerKey);
	
	if (cache == null)
	    return ProvidersList.isProviderEnabled(providerKey);
	
	return cache.booleanValue();
    }
    
    public synchronized Severity getErrorSeverity(String providerKey, String errorKey) {
	Map<String, Severity> error2Severity = key2Error2Severity.get(providerKey);
	
	if (error2Severity == null)
	    return ProvidersList.getErrorSeverity(providerKey, errorKey);
	
	Severity cache = error2Severity.get(errorKey);
	
	if (cache == null)
	    return ProvidersList.getErrorSeverity(providerKey, errorKey);
	    
	return cache;
    }
    
    public synchronized void setProviderEnabled(String providerKey, boolean enabled) {
        key2Enabled.put(providerKey, Boolean.valueOf(enabled));
	
	panel.firePropertyChange(AdvancedHintsPanel.PROP_CHANGED, null, null);
    }

    public synchronized void setSeverity(String providerKey, String errorKey, Severity severity) {
	Map<String, Severity> error2Severity = key2Error2Severity.get(providerKey);
	
	if (error2Severity == null) {
	    key2Error2Severity.put(providerKey, error2Severity = new HashMap<String, Severity>());
	}
	
	error2Severity.put(errorKey, severity);
	
	panel.firePropertyChange(AdvancedHintsPanel.PROP_CHANGED, null, null);
    }
    
    public synchronized List/*<ProviderDescription>*/ getDescriptions() {
        return ProvidersListAccessor.INSTANCE.getDescriptions();
    }
    
    public void rollBack() {
	key2Enabled = new HashMap<String, Boolean>();
	key2Error2Severity = new HashMap<String, Map<String, Severity>>();
        eagerness = (-1);
    }
    
    public void commit() {
	for (Entry<String, Boolean> e : key2Enabled.entrySet()) {
	    String key = e.getKey();
	    Boolean value = e.getValue();
	    
	    ProvidersListAccessor.INSTANCE.setProviderEnabled(key, value.booleanValue());
	}

	for (Entry<String, Map<String, Severity>> eP : key2Error2Severity.entrySet()) {
	    String key = eP.getKey();
	    Map<String, Severity> error2Severity = eP.getValue();
	    
	    for (Entry<String, Severity> e : error2Severity.entrySet()) {
		String errorKey = e.getKey();
		Severity severity = e.getValue();
		
		ProvidersListAccessor.INSTANCE.setSeverity(key, errorKey, severity);
	    }
	}
	
        
	key2Enabled = new HashMap<String, Boolean>();
	key2Error2Severity = new HashMap<String, Map<String, Severity>>();
        eagerness = (-1);
    }
    
    public boolean isModified() {
	return !key2Enabled.isEmpty() || !key2Error2Severity.isEmpty() || (eagerness != (-1));
    }
}
