/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.masterfs;

import org.openide.filesystems.*;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Iterator;
import java.util.HashSet;
import java.awt.*;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;

public class Utils {

    static String getString(String s) {
        try {
            return NbBundle.getBundle("org.netbeans.modules.masterfs.resources.Bundle", //NOI18N
                    java.util.Locale.getDefault(), MasterFileSystem.class.getClassLoader()).getString(s);
        } catch (MissingResourceException msx) {
            return "";
        }
    }

    static String formatString(String excName, Object[] args) {
        String format = getString(excName);
        if (args == null)
            return format;
        else
            return java.text.MessageFormat.format(format, args);
    }

    static void throwIOException(String format, Object[] args) throws IOException {
        throwIOException(new IOException(formatString(format, args)));
    }

    static void throwIOException(IOException exc2Fire) throws IOException {
        throw exc2Fire;
    }

    static Image getRootIcon(int iconType, Object obj) {
        try {
            BeanInfo bI = Utilities.getBeanInfo(obj.getClass());
            Image img = bI.getIcon(iconType);
            return img;
        } catch (IntrospectionException iex) {
            return null;
        }
    }

    static Set transformSet (final Set files) {
        final Set transformedSet = new HashSet ();
        
        Iterator it = files.iterator();
        while (it.hasNext()) {
            MasterFileObject mfo = (MasterFileObject)it.next();
            FileObject fo = mfo.getDelegate().get(true);
            if (fo != null) {
                transformedSet.add(fo);            
            }
        }
        return transformedSet;
    }
    

    static ResourcePath getResource (File f) {
        String path;
        try {
            path = f.getCanonicalPath();
        } catch (IOException iex) {
            path = f.getAbsolutePath();
        }
        return new ResourcePath (path);
    }

    static Set transformToDelegates(java.util.Set foSet, boolean prefered) {
        Set retVal = new HashSet();
        Iterator it = foSet.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof MasterFileObject) {
                FileObject fo;
                if (prefered) {                  
                    MasterFileObject hfo = (MasterFileObject) obj;
                    fo = hfo.getDelegate().getPrefered();
                } else {
                    MasterFileObject hfo = (MasterFileObject) obj;
                    fo = hfo.getDelegate().get();
                }

                if (fo != null)
                    retVal.add(fo);
            }
        }
        return retVal;
    }

}
